% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continuous_refimg.R
\name{refImageContinuous}
\alias{refImageContinuous}
\title{\code{refImageContinuous} returns the reference image, calculated using the
\code{method}.
This image represents the basic measure for the filters in SPUTNIK.}
\usage{
refImageContinuous(
  msiData,
  method = "sum",
  mzQueryRef = numeric(),
  mzTolerance = Inf,
  useFullMZRef = TRUE,
  doSmooth = FALSE,
  smoothSigma = 2,
  alignTo = "detected",
  invertAligned = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{msiData}{\link[SPUTNIK]{msiDataset} object..}

\item{method}{string (default = "sum"). Method used to calculate the
reference image. Valid values are:
\itemize{
  \item "sum": peak intensities sum
  \item "mean": average peak intensities (without zeros)
  \item "median": median peak intensities (without zeros)
  \item "pca": first principal component scores.
}}

\item{mzQueryRef}{numeric. Mass-to-charge ratios used to calculate the reference image.
Two values are interpreted as interval, multiple or single values are searched
in the m/z vector. It overrides the \code{useFullMZRef} argument.}

\item{mzTolerance}{numeric (default = Inf). Search window in parts-per-million units
for the \code{mzQueryRef}.}

\item{useFullMZRef}{logical (default = \code{TRUE}). Whether all peaks should be
used to calculate the reference image. Ignored if \code{mzQueryRef} is provided.}

\item{doSmooth}{logical (default = FALSE). If \code{TRUE}, the reference image is
smoothed using a Gaussian kernel.}

\item{smoothSigma}{numeric (default = 2). Standard deviation of the smoothing 
Gaussian kernel.}

\item{alignTo}{string (default = "detected"). The reference image is aligned
to the image representing:
\itemize{
 \item "detected": number of detected peaks
 \item "tic": total-ion-count image
}
The reference image will have a positive Pearson's correlation with the selected image.}

\item{invertAligned}{logical (default = FALSE). If \code{TRUE}, the reference image
has negative correlation with the selected image in \code{alignTo}.}

\item{verbose}{logical (default = TRUE). Additional output text.}
}
\description{
\code{refImageContinuous} returns the reference image, calculated using the
\code{method}.
This image represents the basic measure for the filters in SPUTNIK.
}
\details{
Function to extract the continuous reference image from a 
\code{\link{msi.dataset-class}} object.
The continuous reference image represents the spatial location of the sample.
By default, it is aligned with either the image representing the number of detected
peaks, or the total-ion-count in all pixels. It is expected to be higher in the
region occupied by the sample (positive correlation with the mask representing
the real sample pixels). In some cases, the alignment images can have higher
values in the pixels outside of the sample. In these circumstances, the argument
\code{invertAligned} should be set to \code{TRUE}.
}
\examples{
## Load package
library("SPUTNIK")

## Mass spectrometry intensity matrix
X <- matrix(rnorm(200), 20, 40)
X[X < 0] <- 0

## Print original dimensions
print(dim(X))

## m/z vector
mzVector <- seq(600, 900, by = (900 - 600) / 39)

## Read the image size
imSize <- c(5, 4)

## Construct the ms.dataset object
msiX <- msiDataset(X, mzVector, imSize[1], imSize[2])

## Calculate the reference and ROI images from the ms.dataset-class object msiX.
## The reference is calculated as the first principal component scores scaled
## in [0, 1]; the binary ROI is calculated applying k-means on the entire dataset.
## Use only m/z values in the range of [700, 900]. The interval extremal values
## are matched within a tolerance of 50 ppm.

refImg <- refImageContinuous(msiX, method = "sum")
roiImg <- refImageBinaryOtsu(refImg)

## Plot the reference and region of interest ROI
## plot(ref.roi$Reference)
## plot(ref.roi$ROI)
}
\seealso{
msiDataset
}
