% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_taxon_id.R
\name{search_taxon_id}
\alias{search_taxon_id}
\title{Search taxon IDs}
\format{
query:
\describe{
\item{taxonIDs}{an array of species' ids}
\item{familyID}{family ID, unique value}
\item{scientificName}{the scientific name, or part of the scientific name, supports Latin names and Chinese}
\item{commonName}{common name, or part of common name}
}
}
\usage{
search_taxon_id(query = NULL, name = "scientificName", mc.cores = 2)
}
\arguments{
\item{query}{\code{string} familyID ,scientificName or commonName.}

\item{name}{\code{character} name = c("familyID","scientificName","commonName"),the default value is "scientificName".}

\item{mc.cores}{The number of cores to use, i.e. at most how many child processes will be run simultaneously. The option is initialized from environment variable MC_CORES if set. Must be at least one, and parallelization requires at least two cores,see [mclapply] for details.}
}
\value{
dataframe
}
\description{
Search taxon IDs via familyID ,scientificName and commonName.
}
\details{
Visit the website \url{http://sp2000.org.cn/api/document} for more details
}
\examples{
\dontrun{
##Set your key
set_search_key <- "your apiKey"

##Search family IDs via family name
familyid <- search_family_id(query = "Anguillidae")

##Search taxon IDs via familyID
taxonid <- search_taxon_id(query = familyid$familyIDs,name = "familyID")

##Search taxon IDs via scientificName
taxonid <- search_taxon_id(query = c("Anguilla marmorata","Anguilla japonica",
                        "Anguilla bicolor","Anguilla nebulosa",
                        "Anguilla luzonensis"),
                        name = "scientificName")

}
}
\author{
Liuyong Ding
}
