% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/FuGePSD.R
\name{Rule.evaluate}
\alias{Rule.evaluate}
\title{Evaluate a single rule.}
\usage{
Rule.evaluate(rule, dataset, data, categoricalValues, numericalValues,
  t_norm = 1, ruleWeight = 0)
}
\arguments{
\item{rule}{The rule we want to evaluate (Class "Rule").}

\item{dataset}{The keel dataset object with the examples to compare with the rule (Class "keel")}

\item{data}{Matrix with the data of the dataset, one colum per rule. The data must not contain the last column, the class. (use .separar for this task and convert the list into a matrix)}

\item{categoricalValues}{a logical vector indicating which attributes in the dataset are categorical}

\item{numericalValues}{a logical vector indicating which attributes in the dataset are numerical}

\item{t_norm}{The T-norm to use. 0 for minimum t-norm, 1 for product t-norm (default: 1)}

\item{ruleWeight}{An integer with the rule weighting method. \itemize{
\item 0 -> Classic Certainty Factor weight
\item 1 -> Penalized Certainty Factor weight II
\item 2 > Penalized Certainty Factor weight IV
\item 3 -> No Rule Weight
}}
}
\value{
The rule evaluated.
}
\description{
Evaluate a single rule.
}

