% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/syc.R
\docType{data}
\name{syc}
\alias{syc}
\title{syc data}
\format{
This data frame contains the following columns:

stratum: stratum number

psu: psu number, (= facility number for residents in strata 1-5 and person number for residents in strata 6-16)

facility: facility number

facsize: number of eligible residents in psu

finalwt: final weight

randgrp:  random group number

age: age of resident (99=missing)

race: race of resident (1 = white; 2 = Black; 3 = Asian/Pacific Islander; 4 = American Indian, Aleut, Eskimo; 5 = Other; 9 = Missing)

ethnicty: 1 = Hispanic, 0 = not Hispanic, 9=missing

educ: highest grade attended before sent to correctional institution (00 = Never attended school; 01 - 12 = highest grade attended;13 = GED; 14 = Other; 99=missing)

gender: 1 = male, 2 = female, 9 = missing

livewith: Who did you live with most of the time you were growing up? (1 = Mother only, 2 = Father only 3 = Both mother and father,4 = Grandparents, 5 = Other relatives, 6 = Friends, 7 = Foster home,8 = Agency or institution, 9 = Someone else, 99 = Blank)

famtime: Has anyone in your family, such as your mother, father,brother, sister, ever served time in jail or prison? (1 = Yes, 2 = No, 7 = Don't know, 9 = Blank)

crimtype: most serious crime in current offense

\{1 = violent (e.g., murder, rape, robbery, assault)

2 = property (e.g. burglary, larceny, arson, fraud, motor vehicle theft)

3 = drug (drug possession or traffcking)

4 = public order (weapons violation, perjury, failure to appear in court)

5 = juvenile status offense (truancy, running away, incorrigible behavior)

9 = missing
\}

everviol: ever put on probation or sent to correctional inst for violent offense (1 = yes, 0 = no)

numarr: number of times arrested (99=missing)

probtn: number of times on probation (99=missing)

corrinst: number of times previously committed to correctional institution (99=missing)

evertime: Prior to being sent here did you ever serve time in a correctional institution? ( 1 = yes, 2 = no, 9 = missing)

prviol: =1 if previously arrested for violent offense, 0 otherwise

prprop: =1 if previously arrested for property offense, 0 otherwise

prdrug: =1 if previously arrested for drug offense, 0 otherwise

prpub: =1 if previously arrested for public order offense, 0 otherwise

prjuv: =1 if previously arrested for juvenile status offense, 0 otherwise

agefirst: age first arrested (99=missing)

usewepn: Did you use a weapon . . . for this incident? (1 = Yes, 2 = No, 9 = Blank)

alcuse: Did you drink alcohol at all during the year before being sent here this time? (1 = Yes; 2 = No, didn't drink during year before; 3 = No, don't drink at all, 9 = missing)

everdrug: Ever used illegal drugs; 0=no, 1=yes, 9=missing
}
\usage{
data(syc)
}
\description{
Selected variables from the Survey of Youth in Custody (Beck et al., 1988). Source:
U.S. Department of Justice (1989). Strata 6-16 each contain one facility; the psus in those
strata are residents. In strata 1-5, the psus are facilities. The number of facilities in the
population ( N h ) for those five facilities are: N 1 = 99 , N 2 = 39 , N 3 = 30 , N 4 = 13 , N 5 = 14 .
Eleven facilities are sampled from stratum 1 and seven facilities are sampled from each of
strata 2 through 5.
}
\references{
Lohr (2021). Sampling: Design and Analysis, 3rd Edition.
}
\keyword{datasets}
