% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modifyEquCons.R
\name{defaultEquMu}
\alias{defaultEquMu}
\title{Default settings for equality handling mechanism}
\usage{
defaultEquMu()
}
\value{
equHandle, a list with the following elements: 
   \item{active}{  [TRUE] if set to TRUE the equality-handling (EH) technique is activated. The EH 
       technique transforms each equality constraint \eqn{h(\vec{x})=0} into two inequality  
       constraints \eqn{h(\vec{x})-\mu <0} and \eqn{-h(\vec{x})-\mu<0 } with an adaptively  
       decaying margin \eqn{\mu}.  }
   \item{equEpsFinal}{[1e-07] lower bound for margin \eqn{\mu}. \code{equEpsFinal} should be set
       to a small but non-zero value (larger than machine accuracy).  }
   \item{initType}{["TAV"] the equality margin \eqn{\mu} can be initialized with one of these approaches:\cr ["TAV"|"TMV"|"EMV"|"useGrange"]\cr
   \strong{TAV}:  (Total Absolute Violation) takes the median of the sum of violations of the initial population.
   \cr \strong{TMV}: (Total Maximum Violation) takes the median of the maximum violation of the initial population
   \cr \strong{EMV}: takes the median of the maximum violation of equality constraints of the initial population
   \cr \strong{useGrange}: takes the average of the ranges of the equality constraint functions}
   \item{epsType}{["SAexpFunc"] type of the function used to modify margin \eqn{\mu} during the optimization process can be one of ["SAexpFunc"|"expFunc"|"Zhang"|"CONS"]. see \code{\link{modifyMu}}.}
   \item{dec}{[1.5] decay factor for margin \eqn{\mu}. see \code{\link{modifyMu}}}
   \item{refine}{[TRUE] enables the refine mechanism f the equality handling mechanism.}
   \item{refineMaxit}{maximum number of iterations used in the refine step. Note that the refine step runs on the surrogate models and does not impose any extra real function evaluation.}
}
\description{
Sets suitable defaults for the equality handling part of SACOBRA. \cr
\cr The EH technique transforms each equality constraint \eqn{h(\vec{x})=0} into two inequality  
       constraints \eqn{h(\vec{x})-\mu <0} and \eqn{-h(\vec{x})-\mu<0 } with an adaptively  
       decaying margin \eqn{\mu}.
\cr \cr If \code{refine} parameter is set to TRUE, then a refine mechanism is applied to shift the best found solution within the equality margin \eqn{\mu} toward the feasible subspace by minimizing the sum of squared constraint surrogates with a conjugate gradient method.        
\deqn{\mbox{Minimize}\quad \sum_i( max(0,g_i(x))^2 )  + \sum_j ( h_j(x)^2 )}
}
\details{
With the call \code{\link{setOpts}(equHandle,defaultEquMu())} it is possible to extend a partial list 
\code{equHandle} list which is set by user to a list containing all \code{equHandle}-elements (the missing ones are taken from 
\code{defaultEquMu()}). 
These settings are used by \code{\link{cobraInit}} for initializing the equality margin \eqn{\mu} and by the internal functions \code{\link{updateCobraEqu}} and \code{\link{modifyMu}}. 
The minimization step of refine mechanism is done by \code{L-BFGS-B} method in \code{optim} function from \code{stats} package.
}
\seealso{
\code{\link{updateCobraEqu}}, \code{\link{modifyMu}}
}
