% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_experiment.R
\name{read_experiment}
\alias{read_experiment}
\title{Read experiment data.}
\usage{
read_experiment(
  filename,
  format = NA,
  interpolate = FALSE,
  project.dir = NA,
  data.dir = project.dir,
  cluster = NULL,
  author.note = "",
  verbose = FALSE
)
}
\arguments{
\item{filename}{A spreadsheet file containing a description of the experiment
or a JSON file containing an exported experiment.}

\item{format}{An experiment description for reading raw data can be provided
as an Excel spreadsheet ('excel') or as a comma-delimited ('csv') or
tab-delimited ('tab', 'tsv', 'txt' or 'text') text file. The value 'json'
indicates that the file is an archived experiment in the JSON format (as
generated by \code{\link{export_json}}). Default (\code{NA}) is to guess
the format from the file extension.}

\item{interpolate}{This is passed to the \code{\link{read_path}} function and
specifies whether missing data points will be interpolated when reading raw
swim path data. Default is \code{FALSE}.}

\item{project.dir}{A directory path specifying where the files needed for
processing the experiment are stored. Default (\code{NA}) means the project
files are in the same directory as the experiment description (specified by
\code{filename}). Ignored if \code{format = "json"}.}

\item{data.dir}{A directory path specifying where the raw data are stored.
All paths specified in the experiment description spreadsheet are
interpreted as being relative to the \code{data.dir} directory. Default is
the same directory as \code{project.dir}. Ignored if \code{format =
"json"}.}

\item{cluster}{A cluster object as generated by
\code{\link[parallel]{makeCluster}} or similar.}

\item{author.note}{Optional text describing the experiment. This might be
useful if the data is to be published or otherwise shared. Appropriate
information might be author names and a link to a publication or website.}

\item{verbose}{Should feedback be printed to the console. This is only useful
for debugging and takes a little longer to run. Default is \code{FALSE}.}
}
\value{
An \code{rtrack_experiment} object containing a complete description
  of the experiment.
}
\description{
Reads a spreadsheet containing a description of all the files required for an
experiment to allow batch execution.
}
\details{
Information about a full experiment can be assembled into a spreadsheet (
currently Excel and CSV formats are supported) and used to process large
numbers of files in one batch. The project directory (\code{project.dir}) is
where the arena description files are found. This will typically be the same
place as the experiment description file (and is set to be this by default).
This does not need to be the same as the current working directory. An
optional data directory (\code{data.dir}) can also be specified separately
allowing the storage-intensive raw data to be kept in a different location
(for example on a remote server). Together, these options allow for
flexibility in managing your raw data storage. Individual tracks are
associated with their raw data file, experimental group metadata, an arena
and any other parameters that the strategy-calling methods require. Required
columns are "_TrackID", "_TargetID", "_Day", "_Trial", "_Arena" "_TrackFile"
and "_TrackFileFormat" (note the leading underscore "_"). Any additional
columns (without a leading underscore) will be interpreted as user-defined
factors or other metadata and will be passed on to the final analysis objects
and thus be available for statistical analysis.

For larger experiments, a computing cluster (using the
\code{\link[parallel]{parallel}} package) can be specified, which will be
passed to analysis functions and allow the track analysis to be performed in
parallel.
}
\examples{
require(Rtrack)
experiment.description = system.file("extdata", "Minimal_experiment.xlsx",
  package = "Rtrack")
experiment = read_experiment(experiment.description)

}
\seealso{
\code{\link{read_path}}, \code{\link{read_arena}},
  \code{\link{check_experiment}}.
}
