% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db-lib.R
\docType{class}
\name{PolyhedraDatabase}
\alias{PolyhedraDatabase}
\title{Polyhedra database}
\description{
Scrapes all polyhedra in data folder to save a representation which
is accessible by the final users upon call to \code{getPolyhedron()}.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{version}}{version of database file}

\item{\code{polyhedra.rds.file}}{path of rds database file}

\item{\code{sources.config}}{Sources configuration for scraping different sources}

\item{\code{ledger}}{rr ledger of scraping process}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{PolyhedraDatabase$new()}}
\item \href{#method-getVersion}{\code{PolyhedraDatabase$getVersion()}}
\item \href{#method-configPolyhedraRDSPath}{\code{PolyhedraDatabase$configPolyhedraRDSPath()}}
\item \href{#method-existsSource}{\code{PolyhedraDatabase$existsSource()}}
\item \href{#method-addSourceConfig}{\code{PolyhedraDatabase$addSourceConfig()}}
\item \href{#method-existsPolyhedron}{\code{PolyhedraDatabase$existsPolyhedron()}}
\item \href{#method-getPolyhedraSourceDir}{\code{PolyhedraDatabase$getPolyhedraSourceDir()}}
\item \href{#method-getPolyhedronFilename}{\code{PolyhedraDatabase$getPolyhedronFilename()}}
\item \href{#method-getPolyhedron}{\code{PolyhedraDatabase$getPolyhedron()}}
\item \href{#method-addPolyhedron}{\code{PolyhedraDatabase$addPolyhedron()}}
\item \href{#method-configPolyhedraSource}{\code{PolyhedraDatabase$configPolyhedraSource()}}
\item \href{#method-saveRDS}{\code{PolyhedraDatabase$saveRDS()}}
\item \href{#method-cover}{\code{PolyhedraDatabase$cover()}}
\item \href{#method-scrape}{\code{PolyhedraDatabase$scrape()}}
\item \href{#method-testRR}{\code{PolyhedraDatabase$testRR()}}
\item \href{#method-generateTestTasks}{\code{PolyhedraDatabase$generateTestTasks()}}
\item \href{#method-schedulePolyhedraSources}{\code{PolyhedraDatabase$schedulePolyhedraSources()}}
\item \href{#method-getAvailableSources}{\code{PolyhedraDatabase$getAvailableSources()}}
\item \href{#method-getAvailablePolyhedra}{\code{PolyhedraDatabase$getAvailablePolyhedra()}}
\item \href{#method-clone}{\code{PolyhedraDatabase$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new PolyhedraDatabase object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedraDatabase$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A new `PolyhedraDatabase` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getVersion"></a>}}
\if{latex}{\out{\hypertarget{method-getVersion}{}}}
\subsection{Method \code{getVersion()}}{
get the version of the current object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedraDatabase$getVersion()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Database version
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-configPolyhedraRDSPath"></a>}}
\if{latex}{\out{\hypertarget{method-configPolyhedraRDSPath}{}}}
\subsection{Method \code{configPolyhedraRDSPath()}}{
sets the path of the RDS object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedraDatabase$configPolyhedraRDSPath()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Database version
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-existsSource"></a>}}
\if{latex}{\out{\hypertarget{method-existsSource}{}}}
\subsection{Method \code{existsSource()}}{
Determines if the source exists on
  the database
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedraDatabase$existsSource(source)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source}}{source description}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
boolean value
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addSourceConfig"></a>}}
\if{latex}{\out{\hypertarget{method-addSourceConfig}{}}}
\subsection{Method \code{addSourceConfig()}}{
add  source.config to the database
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedraDatabase$addSourceConfig(source.config)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source.config}}{SourceConfig object able to scrape source polyhedra definitions}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
PolyhedraDatabase object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-existsPolyhedron"></a>}}
\if{latex}{\out{\hypertarget{method-existsPolyhedron}{}}}
\subsection{Method \code{existsPolyhedron()}}{
Determines if the database includes a polyhedron which name
matches the parameter value
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedraDatabase$existsPolyhedron(source = "netlib", polyhedron.name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source}}{source description}

\item{\code{polyhedron.name}}{polyhedron description}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
boolean value
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getPolyhedraSourceDir"></a>}}
\if{latex}{\out{\hypertarget{method-getPolyhedraSourceDir}{}}}
\subsection{Method \code{getPolyhedraSourceDir()}}{
gets polyhedra sources folder
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedraDatabase$getPolyhedraSourceDir(source, create.dir = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source}}{source description}

\item{\code{create.dir}}{if dir does not exists, create it}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
string with polyhedra sources path
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getPolyhedronFilename"></a>}}
\if{latex}{\out{\hypertarget{method-getPolyhedronFilename}{}}}
\subsection{Method \code{getPolyhedronFilename()}}{
gets the filename of the polyhedron matching parameter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedraDatabase$getPolyhedronFilename(source, polyhedron.name, extension)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source}}{source description}

\item{\code{polyhedron.name}}{polyhedron description}

\item{\code{extension}}{extension of the polyhedron filename}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
string with polyhedron filename
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getPolyhedron"></a>}}
\if{latex}{\out{\hypertarget{method-getPolyhedron}{}}}
\subsection{Method \code{getPolyhedron()}}{
gets polyhedron object which name
matches the parameter value
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedraDatabase$getPolyhedron(
  source = "netlib",
  polyhedron.name,
  strict = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source}}{source description}

\item{\code{polyhedron.name}}{polyhedron description}

\item{\code{strict}}{halts execution if polyhedron not found}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Polyhedron object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addPolyhedron"></a>}}
\if{latex}{\out{\hypertarget{method-addPolyhedron}{}}}
\subsection{Method \code{addPolyhedron()}}{
add polyhedron object to the database
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedraDatabase$addPolyhedron(
  source = "netlib",
  source.filename,
  polyhedron,
  overwrite = FALSE,
  save.on.change = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source}}{source description}

\item{\code{source.filename}}{filename of the polyhedron source definition}

\item{\code{polyhedron}}{polyhedron object}

\item{\code{overwrite}}{overwrite exiting definition}

\item{\code{save.on.change}}{saves Database state after operation}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Polyhedron object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-configPolyhedraSource"></a>}}
\if{latex}{\out{\hypertarget{method-configPolyhedraSource}{}}}
\subsection{Method \code{configPolyhedraSource()}}{
Process parameter filenames using source.config parameter
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedraDatabase$configPolyhedraSource(
  source.config,
  source.filenames = NULL,
  max.quant = 0,
  save.on.change = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source.config}}{source configuration for scraping files}

\item{\code{source.filenames}}{filenames of the polyhedron source definition}

\item{\code{max.quant}}{maximum filenames to process}

\item{\code{save.on.change}}{saves Database state after operation}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Modified `PolyhedraDatabase` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-saveRDS"></a>}}
\if{latex}{\out{\hypertarget{method-saveRDS}{}}}
\subsection{Method \code{saveRDS()}}{
saveRDS
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedraDatabase$saveRDS(save.on.change = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{save.on.change}}{saves Database state after operation}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
saveRDS return status
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cover"></a>}}
\if{latex}{\out{\hypertarget{method-cover}{}}}
\subsection{Method \code{cover()}}{
Cover objects and applies covering.code parameter
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedraDatabase$cover(
  mode,
  sources = names(self$sources.config),
  covering.code,
  polyhedra.names = NULL,
  max.quant = 0,
  save.on.change = FALSE,
  seed = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mode}}{covering mode. Available values are "scrape.queued", "scrape.retry","skipped",  "test"}

\item{\code{sources}}{sources names}

\item{\code{covering.code}}{code for applying in covering}

\item{\code{polyhedra.names}}{polyhedra names to cover (optional)}

\item{\code{max.quant}}{maximum numbers of polyhedra to cover}

\item{\code{save.on.change}}{saves Database state after operation}

\item{\code{seed}}{seed for deterministic random generator}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with resulting objects covered
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-scrape"></a>}}
\if{latex}{\out{\hypertarget{method-scrape}{}}}
\subsection{Method \code{scrape()}}{
Scrape polyhedra queued sources
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedraDatabase$scrape(
  mode = "scrape.queued",
  sources = names(self$sources.config),
  max.quant = 0,
  time2scrape.source = 30,
  save.on.change = FALSE,
  skip.still.queued = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mode}}{covering mode. Available values are "scrape.queued", "scrape.retry","skipped",  "test"}

\item{\code{sources}}{sources names}

\item{\code{max.quant}}{maximum numbers of polyhedra to cover}

\item{\code{time2scrape.source}}{maximum time to spend scraping each source}

\item{\code{save.on.change}}{saves Database state after operation}

\item{\code{skip.still.queued}}{Flag unscraped files with status `skipped``}

\item{\code{covering.code}}{code for applying in covering}

\item{\code{polyhedra.names}}{polyhedra names to cover (optional)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with resulting objects covered
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-testRR"></a>}}
\if{latex}{\out{\hypertarget{method-testRR}{}}}
\subsection{Method \code{testRR()}}{
testRR
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedraDatabase$testRR(sources = names(self$sources.config), max.quant = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sources}}{sources names}

\item{\code{max.quant}}{maximum numbers of polyhedra to cover}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with resulting objects tested
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-generateTestTasks"></a>}}
\if{latex}{\out{\hypertarget{method-generateTestTasks}{}}}
\subsection{Method \code{generateTestTasks()}}{
generate Test tasks for selected polyhedra
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedraDatabase$generateTestTasks(
  sources = names(self$sources.config),
  polyhedra.names = NULL,
  TestTaskClass,
  max.quant = 0
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sources}}{sources names}

\item{\code{polyhedra.names}}{polyhedra names to cover (optional)}

\item{\code{TestTaskClass}}{an R6 TestTaskClass class}

\item{\code{max.quant}}{maximum numbers of polyhedra to cover}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with resulting TestTasks generated
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-schedulePolyhedraSources"></a>}}
\if{latex}{\out{\hypertarget{method-schedulePolyhedraSources}{}}}
\subsection{Method \code{schedulePolyhedraSources()}}{
Schedules polyhedra sources for scraping
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedraDatabase$schedulePolyhedraSources(
  sources.config = getPackageEnvir(".available.sources"),
  source.filenames = NULL,
  max.quant = 0,
  save.on.change = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sources.config}}{sources configurations for scraping files}

\item{\code{source.filenames}}{filenames of the polyhedron source definition}

\item{\code{max.quant}}{maximum filenames to process}

\item{\code{save.on.change}}{saves Database state after operation}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Modified `PolyhedraDatabase` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getAvailableSources"></a>}}
\if{latex}{\out{\hypertarget{method-getAvailableSources}{}}}
\subsection{Method \code{getAvailableSources()}}{
Returns available sources in current database
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedraDatabase$getAvailableSources()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A vector with names of available sources
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getAvailablePolyhedra"></a>}}
\if{latex}{\out{\hypertarget{method-getAvailablePolyhedra}{}}}
\subsection{Method \code{getAvailablePolyhedra()}}{
Retrieves all polyhedron within the source those names match with search.string
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedraDatabase$getAvailablePolyhedra(
  sources = self$getAvailableSources(),
  search.string = NULL,
  ignore.case = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sources}}{sources names}

\item{\code{search.string}}{string for matching polyhedron names}

\item{\code{ignore.case}}{ignore case in search string}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with resulting objects covered
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PolyhedraDatabase$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
