% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fhirClient.R
\name{fhirClient}
\alias{fhirClient}
\title{fhirClient}
\description{
Read and search only client in R for FHIR STU 3.
Based on \href{https://github.com/ewoutkramer/fhir-net-api}{the official HL7 FHIR .NET API.}
}
\section{Usage}{

\preformatted{
client <- fhirClient$new(endpoint)

client$read(location, summaryType = NULL)
client$search(resourceType, criteria = NULL, includes = NULL, pageSize = NULL, summaryType = NULL)
client$searchById(resourceType, id, includes = NULL, summaryType = NULL)
client$wholeSystemSearch(criteria = NULL, includes = NULL, pageSize = NULL, summaryType = NULL)
client$searchParams(params, resourceType = NULL)
client$continue(bundle)

print(client)
}
}

\section{Arguments}{

\describe{
  \item{client}{A \code{fhirClient} object.}
  \item{endpoint}{The URL of the server to connect to.}
  \item{resourceType}{The type of resource to search for.}
  \item{id}{The id of the Resource to search for.}
  \item{summaryType}{Whether to include only return a summary of the Resource(s).}
  \item{location}{The url of the Resource to fetch. This can be a Resource id url or a version-specific.}
  \item{criteria}{The search parameters to filter the Resources on. Each given string is a combined key/value pair (separated by '=').}
  \item{includes}{Paths to include in the search.}
  \item{pageSize}{Asks server to limit the number of entries per page returned.}
  \item{query}{A searchParams object containing the search parameters.}
  \item{bundle}{The bundle as received from the last response.}
}
}

\section{Details}{

\code{$new()} Creates a new fhirClient using a given endpoint.
If the endpoint does not end with a slash (/), it will be added.

\code{$read()} Fetches a typed Resource from a FHIR resource endpoint.

\code{$search()} Search for Resources of a certain type that match the given criteria.

\code{$searchById()} Search for Resources based on a Resource's id.

\code{$wholeSystemSearch()} Search for Resources across the whole server that match the given criteria.

\code{$searchByQuery()} Search for Resources based on a searchParams object.

\code{$continue()} Uses the FHIR paging mechanism to go navigate around a series of paged result Bundles.

\code{print(p)} or \code{p$print()} Shows which endpoint is configured.
}

\examples{
\dontrun{
# Setting up a fhirClient
client <- fhirClient$new("http://vonk.furore.com")
# Read
client$read("Patient/example")

# Search
bundle <- client$search("Patient", c("name=Peter", "address-postalcode=3999"))

while(!is.null(bundle)){
   # Do something useful
   bundle <- client$continue(bundle)
}
}

}
