% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polygons.R
\name{searchAdmLevel}
\alias{searchAdmLevel}
\title{Search for the admLevel by official name}
\usage{
searchAdmLevel(ctryCodes = NULL, admLevelNames, dnldPoly = TRUE,
  downloadMethod = pkgOptions("downloadMethod"),
  gadmVersion = pkgOptions("gadmVersion"),
  gadmPolyType = pkgOptions("gadmPolyType"), custPolyPath = NULL)
}
\arguments{
\item{ctryCodes}{\code{character} The ctryCodes of the country of interest}

\item{admLevelNames}{\code{character} The names to search for}

\item{dnldPoly}{\code{logical} If the country polygon doesn't exist 
should we download it?}

\item{downloadMethod}{The method used to download polygons}

\item{gadmVersion}{The GADM version to use}

\item{gadmPolyType}{The format of polygons to download from GADM}

\item{custPolyPath}{Alternative to GADM. A path to a custom shapefile zip}
}
\value{
character vector of admin level names
}
\description{
Search for the admLevel by official name. Expects the shapefile
    to already exist.
}
\examples{
\dontrun{
searchAdmLevel("KEN", "county")
#returns "KEN_adm1"
}

}
