% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vignette.R
\name{myfun}
\alias{myfun}
\title{Function to test the use of rowcols and lonlats in getCtryNlData}
\usage{
myfun(col, row, lon, lat, val, numPts = 3)
}
\arguments{
\item{col}{character parameter to tell the package to pass in the colrow
values i.e. column and row indices as per the country polygon}

\item{row}{character parameter to tell the package to pass in the colrow
values i.e. column and row indices of non-NA pixels as per the country
polygon}

\item{lon}{character parameter to tell the package to pass in the lonlat
values i.e. column and row indices of non-NA pixels as per the country
polygon}

\item{lat}{character parameter to tell the package to pass in the lonlat
values i.e. column and row indices of non-NA pixels as per the country
polygon}

\item{val}{character variable which will hold the raster values found in
in the raster}

\item{numPts}{integer The number of top pixels to detect}
}
\description{
Function to test the use of rowcols and lonlats in getCtryNlData as
    input to the nlStats parameter.
    
    The function gets the top numPts brightest pixels in a sub-polygon
    or zone and looks at increasing neighbouring distances looking
    for the distance to the first pixel that is 1/2 the value of the
    central pixel.
}
\examples{

\dontrun{
pkgReset();
  system.time(rastGFT92 <-  getCtryNlData(ctryCode = "NGA",
     admLevel = "lowest", nlTypes = "OLS.Y", nlPeriods = "1992",
     removeGasFlares = F, ignoreMissing=FALSE, nlStats = list("myfun")))
   
  pkgOptions(extractMethod="gdal",cropMaskMethod="gdal");
  system.time(gdalGFT92 <-  getCtryNlData(ctryCode = "NGA",
      admLevel = "lowest", nlTypes = "OLS.Y", nlPeriods = "1992",
      removeGasFlares = F, ignoreMissing=FALSE, nlStats="myfun"))
}

}
