% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chi_power_disc.R
\name{chi_power_disc}
\alias{chi_power_disc}
\title{This function finds the power of various chi-square tests for continuous data}
\usage{
chi_power_disc(
  pnull,
  ralt,
  param_alt,
  phat = function(x) -99,
  alpha = 0.05,
  B = 1000,
  nbins = c(50, 10),
  rate = 0,
  minexpcount = 5,
  ChiUsePhat = TRUE
)
}
\arguments{
\item{pnull}{function to find cdf under  null hypothesis}

\item{ralt}{function to generate data under  alternative hypothesis}

\item{param_alt}{vector of parameter values for distribution under alternative hypothesis}

\item{phat}{=function(x) -99, routine to estimate parameters}

\item{alpha}{=0.05, the level of the hypothesis test}

\item{B}{=1000 number of simulation runs to find power}

\item{nbins}{=c(50,10), number of bins for chi square tests}

\item{rate}{=0 rate of Poisson if sample size is random, 0 if sample size is fixed}

\item{minexpcount}{=5 minimal expected bin count required}

\item{ChiUsePhat}{= TRUE, should chi square use minimum chi square method?}
}
\value{
A numeric matrix of power values.
}
\description{
This function finds the power of various chi-square tests for continuous data
}
