% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestry.R
\name{predictInfo}
\alias{predictInfo}
\title{predictInfo-forestry}
\usage{
predictInfo(object, newdata, aggregation = "average")
}
\arguments{
\item{object}{A `forestry` object.}

\item{newdata}{Data on which we want to do predictions. Must be the same length
as the training set if we are doing `oob` or `doubleOOB` aggregation.}

\item{aggregation}{Specifies which aggregation version is used to predict for the
observation, must be one of `average`,`oob`, and `doubleOOB`.}
}
\value{
A list with four entries. `weightMatrix` is a matrix specifying the
 weight given to training observatio i when prediction on observation j.
 `avgIndices` gives the indices which are in the averaging set for each new
 observation. `avgWeights` gives the weights corresponding to each averaging
 observation returned in `avgIndices`. `obsInfo` gives the full observation vectors
 which were used to predict for an observation, as well as the weight given
 each observation.
}
\description{
Get the observations which are used to predict for a set of new
 observations using either all trees (for out of sample observations), or
 tree for which the observation is out of averaging set or out of sample entirely.
}
