% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMassExtinctions.R
\name{plotMassExtinctions}
\alias{plotMassExtinctions}
\title{Plot Mass Extinction Support}
\usage{
plotMassExtinctions(
  mass_extinction_trace,
  mass_extinction_times,
  mass_extinction_name,
  prior_prob,
  return_2lnBF = TRUE
)
}
\arguments{
\item{mass_extinction_trace}{(list; no default) The processed Rev output of
the mass extinction probabilities (output of readTrace()).}

\item{mass_extinction_times}{(numeric; no default) Vector of the fixed grid
of times at which mass extinctions were allowed to occur.}

\item{mass_extinction_name}{(character; no default) The name of the mass
extinction probability parameter (e.g. "mass_extinction_probabilities")
for which support is to be calculated/plotted.}

\item{prior_prob}{(numeric; no default) The per-interval prior probability
of a mass extinction (one minus the p parameter in RevBayes'
dnReversibleJumpMixture()).}

\item{return_2lnBF}{(logical; TRUE) Should the 2ln(BF) be returned (if TRUE)
or simply the BF (if FALSE)?}
}
\value{
A ggplot object
}
\description{
Plots the support (as 2ln Bayes factors) for mass extinctions.
}
\details{
Works only for analyses with a fixed grid where mass extinctions may occur.

The return object can be manipulated. For example, you can change the axis
labels, the color palette, whether the axes are to be linked, or the overall
plotting style/theme, just as with any ggplot object.
}
\examples{
\donttest{

# download the example dataset to working directory
url <-
  "https://revbayes.github.io/tutorials/intro/data/crocs_mass_extinction_probabilities.log"
dest_path <- "crocs_mass_extinction_probabilities.log"
download.file(url, dest_path)

# to run on your own data, change this to the path to your data file
mass_extinction_probability_file <- dest_path

mass_extinction_probabilities <-
              readTrace(mass_extinction_probability_file,burnin = 0.25)

# prior probability of mass extinction at any time
prior_n_expected <- 0.1
n_intervals <- 100
prior_prob <- prior_n_expected/(n_intervals-1)

# times when mass extinctions were allowed
tree_age <- 243.5
interval_times <- tree_age * seq(1/n_intervals,(n_intervals-1) /
                                                   n_intervals,1/n_intervals)

# then plot results:
p <- plotMassExtinctions(mass_extinction_trace=mass_extinction_probabilities,
                         mass_extinction_times=interval_times,
                         mass_extinction_name="mass_extinction_probabilities"
                         ,prior_prob);p

# remove file
# WARNING: only run for example dataset!
# otherwise you might delete your data!
file.remove(dest_path)
}

}
\references{
Kass and Raftery (1995) Bayes Factors.
\emph{JASA}, \bold{90 (430)}, 773-795.
}
