/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.event.impl;

import com.topologi.diffx.event.AttributeEvent;
import com.topologi.diffx.event.CloseElementEvent;
import com.topologi.diffx.event.OpenElementEvent;
import com.topologi.diffx.event.impl.AttributeEventImpl;
import com.topologi.diffx.event.impl.AttributeEventNSImpl;
import com.topologi.diffx.event.impl.CloseElementEventImpl;
import com.topologi.diffx.event.impl.CloseElementEventNSImpl;
import com.topologi.diffx.event.impl.OpenElementEventImpl;
import com.topologi.diffx.event.impl.OpenElementEventNSImpl;

public final class EventFactory {
    private boolean isNamespaceAware = true;

    public EventFactory() {
        this.isNamespaceAware = true;
    }

    public EventFactory(boolean isNamespaceAware) {
        this.isNamespaceAware = isNamespaceAware;
    }

    public OpenElementEvent makeOpenElement(String uri, String name) {
        if (this.isNamespaceAware) {
            return new OpenElementEventNSImpl(uri, name);
        }
        return new OpenElementEventImpl(name);
    }

    public OpenElementEvent makeOpenElement(String uri, String localName, String qName) {
        if (this.isNamespaceAware) {
            return new OpenElementEventNSImpl(uri, localName);
        }
        return new OpenElementEventImpl(qName);
    }

    public CloseElementEvent makeCloseElement(OpenElementEvent open) {
        if (this.isNamespaceAware) {
            return new CloseElementEventNSImpl(open);
        }
        return new CloseElementEventImpl(open);
    }

    public AttributeEvent makeAttribute(String uri, String name, String value) {
        if (this.isNamespaceAware) {
            return new AttributeEventNSImpl("".equals(uri) ? null : uri, name, value);
        }
        return new AttributeEventImpl(name, value);
    }

    public AttributeEvent makeAttribute(String uri, String localName, String qName, String value) {
        if (this.isNamespaceAware) {
            return new AttributeEventNSImpl("".equals(uri) ? null : uri, localName, value);
        }
        return new AttributeEventImpl(qName, value);
    }
}

