/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtils {
    protected static Logger log = LoggerFactory.getLogger(ResourceUtils.class);

    public static InputStream getResource(String filename) throws IOException {
        URL url;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ResourceUtils.class.getClassLoader();
        }
        if ((url = loader.getResource(filename)) == null) {
            if (filename.contains("jaxb.properties")) {
                log.debug("Not using MOXy, since no resource: " + filename);
            } else {
                log.warn("Couldn't get resource: " + filename);
            }
            throw new IOException(filename + " not found via classloader.");
        }
        InputStream is = url.openConnection().getInputStream();
        return is;
    }
}

