% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleCompute.R
\name{computePcaNbDims}
\alias{computePcaNbDims}
\title{Number of dimensions for PCA}
\usage{
computePcaNbDims(sdev, pca.variance.cum.min = 0.9)
}
\arguments{
\item{sdev}{standard deviation of the principal components (returned from prcomp).}

\item{pca.variance.cum.min}{minimal cumulative variance to retain.}
}
\value{
pca.nb.dims number of dimensions kept.
}
\description{
Compute the number of dimensions to keep after a Principal Components Analysis, according to a threshold on the cumulative variance.
}
\details{
computePcaNbDims computes the number of dimensions to keep after a Principal Components Analysis, according to a threshold on the cumulative variance
}
\examples{
dat <- rbind(matrix(rnorm(100, mean = 0, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 2, sd = 0.3), ncol = 2), 
             matrix(rnorm(100, mean = 4, sd = 0.3), ncol = 2))
tf <- tempfile()
write.table(dat, tf, sep=",", dec=".")

x <- importSample(file.features=tf, dir.save=tempdir())
res.pca <- computePcaSample(x)
computePcaNbDims(res.pca$pca$sdev)



}
\seealso{
\code{\link{computePcaSample}}
}
\keyword{internal}
