% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_life_cycle.R
\name{plot_life_cycle}
\alias{plot_life_cycle}
\title{Plot a life cycle diagram from a matrix population model}
\usage{
plot_life_cycle(
  matA,
  stages,
  title = NULL,
  shape = "egg",
  fontsize = 10,
  nodefontsize = 12,
  edgecol = "grey"
)
}
\arguments{
\item{matA}{A matrix population model (i.e., a square projection matrix)}

\item{stages}{Optional vector of stage class labels. If missing, it first
attempts to infer them from \code{dimnames(matA)}. If these are also
\code{NULL}, then reverts to integers \code{1:ncol(A)}.}

\item{title}{Optional title for the plot. Defaults to \code{NULL}.}

\item{shape}{The shape to be used for the stages of the diagram. Any node
shape accepted by \code{graphViz} is acceptable.}

\item{fontsize}{Size of the font used in the diagram.}

\item{nodefontsize}{Size of the font used in the node part of the diagram.}

\item{edgecol}{Colour of the arrows in the diagram.}
}
\value{
An object of class \code{grViz} representing the life cycle diagram
}
\description{
Plots the life cycle diagram illustrated by a matrix population model. This
function processes the matrix model and passes the information to the
graphViz function in DiagrammeR. See
\url{http://rich-iannone.github.io/DiagrammeR/}.
}
\examples{
matA <- rbind(
  c(0.1, 0, 0, 0, 1.4),
  c(0.5, 0.2, 0, 0, 0),
  c(0, 0.3, 0.3, 0, 0),
  c(0, 0, 0.4, 0.4, 0.1),
  c(0, 0, 0, 0.1, 0.4)
)

plot_life_cycle(matA)

}
\author{
Owen R. Jones <jones@biology.sdu.dk>
}
\concept{visualisation}
