% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.radviz.R
\name{subset.radviz}
\alias{subset.radviz}
\title{Subsetting a Radviz projection}
\usage{
\method{subset}{radviz}(x, i = TRUE, ...)
}
\arguments{
\item{x}{a radviz object}

\item{i}{A logical vector or expression evaluated on the Radviz object}

\item{...}{further arguments to be passed to or from other methods (not implemented)}
}
\value{
a new Radviz object containing only rows specified in i
}
\description{
Subsetting a Radviz projection
}
\examples{
data(iris)
das <- c('Sepal.Length','Sepal.Width','Petal.Length','Petal.Width')
S <- make.S(das)
rv <- do.radviz(iris,S)
# subset rv
srv <- subset(rv,iris$Species=='setosa')
summary(srv)
sum(iris$Species=='setosa') # 50 objects in srv corresponding to setosa values

}
\author{
Yann Abraham
}
