% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forceTuning.R
\name{tuneForceRatio}
\alias{tuneForceRatio}
\title{Method to compute optimal ratio between repulsive and attractive forces for Freeviz.}
\usage{
tuneForceRatio(
  x,
  classes,
  law = 0,
  steps = 10,
  springs = NULL,
  multilevel = TRUE,
  print = TRUE
)
}
\arguments{
\item{x}{Dataframe or matrix, with observations as rows and attributes as columns}

\item{classes}{Vector with class labels of the observations}

\item{law}{Integer, specifying how forces change with distance: 0 = (inverse) linear, 1 = (inverse) square}

\item{steps}{Number of iterations of the algorithm before re-considering convergence criterion}

\item{springs}{Numeric matrix with initial anchor coordinates. When \code{NULL} (=default), springs are initialized by \code{\link{make.S}}}

\item{multilevel}{Logical, indicating whether multi-level computation should be used. Setting it to TRUE can speed up computations}

\item{print}{Logical, indicating whether information on the iterative procedure should be printed in the R console}
}
\value{
Value of the optimal force ratio (attractive force in the nominator)
}
\description{
Method to compute optimal ratio between repulsive and attractive forces for Freeviz.
}
\details{
Running Freeviz, it is hard to know what weights to specify for the attractive and repulsive forces to optimize the projection result. This function runs an iterative procedure
to find the optimal force ratio. First, a logarithmic grid search is performed, followed by 1D optimization on the refined interval. This approach is less prone to getting stuck in 
a suboptimal local optimum, and requires less Freeviz evaluations than direct 1D optimization
}
\examples{
data(iris)
das <- c('Sepal.Length','Sepal.Width','Petal.Length','Petal.Width')
S <- make.S(das)
rv <- do.radviz(iris,S)
plot(rv,anchors.only=FALSE)
forceRatio <- tuneForceRatio(x = iris[,das], classes = iris$Species)
new.S <- do.optimFreeviz(x = iris[,das], classes = iris$Species, attractG = forceRatio, repelG = 1)
new.rv <- do.radviz(iris,new.S)
plot(new.rv,anchors.only=FALSE)

}
\author{
Nicolas Sauwen
}
