% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_graph.R
\name{n_graph}
\alias{n_graph}
\alias{n_graphF}
\alias{n_graphS}
\title{Graphs of Dependencies}
\usage{
n_graphF(netw, group = 2, fontFamily = "serif", fontSize = 11,
  linkDistance = 50, charge = -100)

n_graphS(netw, group = 2, fontFamily = "serif", fontSize = 14,
  nodeWidth = 30, nodePadding = 10)
}
\arguments{
\item{netw}{a list of class "pkgsnetwork" produced by \code{\link{p_network}}
that describes with nodes and links the dependencies of one or 
several packages (a network).}

\item{group}{integer, currently 1, 2 or 3. The suffix of the "NGroup" column 
in \emph{netw}. Define a scheme for colouring the nodes.}

\item{fontFamily}{character. Either "serif" or "sans-serif".}

\item{fontSize}{integer. The size of the font.}

\item{linkDistance}{integer. The minimal distance of a link between two nodes.}

\item{charge}{integer. A repulsive value between two nodes.}

\item{nodeWidth}{integer. The width of the rectangular nodes in the Sankey graph.}

\item{nodePadding}{integer. The vertical space between two nodes in the same column 
of a Sankey graph.}
}
\description{
These two functions display in the default browser a network of the package dependencies 
as a standard graph \code{n_graphF} (F for force in networkD3 catalogue) or as a Sankey 
graph \code{n_graphS}. The graphs are built (and can be saved) with the \emph{networkD3} 
package. 

Remember that the option \code{p_network(exclpkgs = ...} in \code{\link{p_network}}, 
whose default value \code{TRUE} is equivalent to 
\code{exclpkgs = c("graphics", "grDevices", "methods", "stats", "tools", "utils")}, 
can substantially modify the aspect of the graph, especially for \code{reverse = FALSE}.
}
\examples{
\donttest{
## In real life, download crandb from CRAN or load it from your directory 
## with functions crandb_down() or crandb_load(). 
## In this example, we use a small file.
crandb_load(system.file("data", "zcrandb.rda", package = "RWsearch"))
netw <- p_network(stringr, methods, parallel, stats, utils, reverse = TRUE)
n_graphF(netw)
n_graphS(netw)

n_graphF(p_network(canprot, FatTailsR, actuar, exclpkgs = FALSE))
}
}
