/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.ErrorBasedMeritEvaluator;
import weka.attributeSelection.HoldOutSubsetEvaluator;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.rules.ZeroR;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class ClassifierSubsetEval
extends HoldOutSubsetEvaluator
implements OptionHandler,
ErrorBasedMeritEvaluator {
    static final long serialVersionUID = 7532217899385278710L;
    private Instances m_trainingInstances;
    private int m_classIndex;
    private int m_numAttribs;
    private int m_numInstances;
    private Classifier m_Classifier = new ZeroR();
    private Evaluation m_Evaluation;
    private File m_holdOutFile = new File("Click to set hold out or test instances");
    private Instances m_holdOutInstances = null;
    private boolean m_useTraining = true;

    public String globalInfo() {
        return "Classifier subset evaluator:\n\nEvaluates attribute subsets on training data or a seperate hold out testing set. Uses a classifier to estimate the 'merit' of a set of attributes.";
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(3);
        newVector.addElement(new Option("\tclass name of the classifier to use for accuracy estimation.\n\tPlace any classifier options LAST on the command line\n\tfollowing a \"--\". eg.:\n\t\t-B weka.classifiers.bayes.NaiveBayes ... -- -K\n\t(default: weka.classifiers.rules.ZeroR)", "B", 1, "-B <classifier>"));
        newVector.addElement(new Option("\tUse the training data to estimate accuracy.", "T", 0, "-T"));
        newVector.addElement(new Option("\tName of the hold out/test set to \n\testimate accuracy on.", "H", 1, "-H <filename>"));
        if (this.m_Classifier != null && this.m_Classifier instanceof OptionHandler) {
            newVector.addElement(new Option("", "", 0, "\nOptions specific to scheme " + this.m_Classifier.getClass().getName() + ":"));
            Enumeration enu = ((OptionHandler)((Object)this.m_Classifier)).listOptions();
            while (enu.hasMoreElements()) {
                newVector.addElement((Option)enu.nextElement());
            }
        }
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        String optionString = Utils.getOption('B', options);
        if (optionString.length() == 0) {
            optionString = ZeroR.class.getName();
        }
        this.setClassifier(AbstractClassifier.forName(optionString, Utils.partitionOptions(options)));
        optionString = Utils.getOption('H', options);
        if (optionString.length() != 0) {
            this.setHoldOutFile(new File(optionString));
        }
        this.setUseTraining(Utils.getFlag('T', options));
    }

    public String classifierTipText() {
        return "Classifier to use for estimating the accuracy of subsets";
    }

    public void setClassifier(Classifier newClassifier) {
        this.m_Classifier = newClassifier;
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    public String holdOutFileTipText() {
        return "File containing hold out/test instances.";
    }

    public File getHoldOutFile() {
        return this.m_holdOutFile;
    }

    public void setHoldOutFile(File h) {
        this.m_holdOutFile = h;
    }

    public String useTrainingTipText() {
        return "Use training data instead of hold out/test instances.";
    }

    public boolean getUseTraining() {
        return this.m_useTraining;
    }

    public void setUseTraining(boolean t) {
        this.m_useTraining = t;
    }

    public String[] getOptions() {
        String[] classifierOptions = new String[]{};
        if (this.m_Classifier != null && this.m_Classifier instanceof OptionHandler) {
            classifierOptions = ((OptionHandler)((Object)this.m_Classifier)).getOptions();
        }
        String[] options = new String[6 + classifierOptions.length];
        int current = 0;
        if (this.getClassifier() != null) {
            options[current++] = "-B";
            options[current++] = this.getClassifier().getClass().getName();
        }
        if (this.getUseTraining()) {
            options[current++] = "-T";
        }
        options[current++] = "-H";
        options[current++] = this.getHoldOutFile().getPath();
        if (classifierOptions.length > 0) {
            options[current++] = "--";
            System.arraycopy(classifierOptions, 0, options, current, classifierOptions.length);
            current += classifierOptions.length;
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public Capabilities getCapabilities() {
        Capabilities result;
        if (this.getClassifier() == null) {
            result = super.getCapabilities();
            result.disableAll();
        } else {
            result = this.getClassifier().getCapabilities();
        }
        for (Capabilities.Capability cap : Capabilities.Capability.values()) {
            result.enableDependency(cap);
        }
        return result;
    }

    public void buildEvaluator(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        this.m_trainingInstances = data;
        this.m_classIndex = this.m_trainingInstances.classIndex();
        this.m_numAttribs = this.m_trainingInstances.numAttributes();
        this.m_numInstances = this.m_trainingInstances.numInstances();
        if (!this.m_useTraining && !this.getHoldOutFile().getPath().startsWith("Click to set")) {
            BufferedReader r = new BufferedReader(new FileReader(this.getHoldOutFile().getPath()));
            this.m_holdOutInstances = new Instances(r);
            this.m_holdOutInstances.setClassIndex(this.m_trainingInstances.classIndex());
            if (!this.m_trainingInstances.equalHeaders(this.m_holdOutInstances)) {
                throw new Exception("Hold out/test set is not compatable with training data.\n" + this.m_trainingInstances.equalHeadersMsg(this.m_holdOutInstances));
            }
        }
    }

    public double evaluateSubset(BitSet subset) throws Exception {
        int i;
        double errorRate = 0.0;
        int numAttributes = 0;
        Instances trainCopy = null;
        Instances testCopy = null;
        Remove delTransform = new Remove();
        delTransform.setInvertSelection(true);
        trainCopy = new Instances(this.m_trainingInstances);
        if (!this.m_useTraining) {
            if (this.m_holdOutInstances == null) {
                throw new Exception("Must specify a set of hold out/test instances with -H");
            }
            testCopy = new Instances(this.m_holdOutInstances);
        }
        for (i = 0; i < this.m_numAttribs; ++i) {
            if (!subset.get(i)) continue;
            ++numAttributes;
        }
        int[] featArray = new int[numAttributes + 1];
        int j = 0;
        for (i = 0; i < this.m_numAttribs; ++i) {
            if (!subset.get(i)) continue;
            featArray[j++] = i;
        }
        featArray[j] = this.m_classIndex;
        delTransform.setAttributeIndicesArray(featArray);
        delTransform.setInputFormat(trainCopy);
        trainCopy = Filter.useFilter(trainCopy, delTransform);
        if (!this.m_useTraining) {
            testCopy = Filter.useFilter(testCopy, delTransform);
        }
        this.m_Classifier.buildClassifier(trainCopy);
        this.m_Evaluation = new Evaluation(trainCopy);
        if (!this.m_useTraining) {
            this.m_Evaluation.evaluateModel(this.m_Classifier, testCopy, new Object[0]);
        } else {
            this.m_Evaluation.evaluateModel(this.m_Classifier, trainCopy, new Object[0]);
        }
        errorRate = this.m_trainingInstances.classAttribute().isNominal() ? this.m_Evaluation.errorRate() : this.m_Evaluation.meanAbsoluteError();
        this.m_Evaluation = null;
        return -errorRate;
    }

    public double evaluateSubset(BitSet subset, Instances holdOut) throws Exception {
        int i;
        int numAttributes = 0;
        Instances trainCopy = null;
        Instances testCopy = null;
        if (!this.m_trainingInstances.equalHeaders(holdOut)) {
            throw new Exception("evaluateSubset : Incompatable instance types.\n" + this.m_trainingInstances.equalHeadersMsg(holdOut));
        }
        Remove delTransform = new Remove();
        delTransform.setInvertSelection(true);
        trainCopy = new Instances(this.m_trainingInstances);
        testCopy = new Instances(holdOut);
        for (i = 0; i < this.m_numAttribs; ++i) {
            if (!subset.get(i)) continue;
            ++numAttributes;
        }
        int[] featArray = new int[numAttributes + 1];
        int j = 0;
        for (i = 0; i < this.m_numAttribs; ++i) {
            if (!subset.get(i)) continue;
            featArray[j++] = i;
        }
        featArray[j] = this.m_classIndex;
        delTransform.setAttributeIndicesArray(featArray);
        delTransform.setInputFormat(trainCopy);
        trainCopy = Filter.useFilter(trainCopy, delTransform);
        testCopy = Filter.useFilter(testCopy, delTransform);
        this.m_Classifier.buildClassifier(trainCopy);
        this.m_Evaluation = new Evaluation(trainCopy);
        this.m_Evaluation.evaluateModel(this.m_Classifier, testCopy, new Object[0]);
        double errorRate = this.m_trainingInstances.classAttribute().isNominal() ? this.m_Evaluation.errorRate() : this.m_Evaluation.meanAbsoluteError();
        this.m_Evaluation = null;
        return -errorRate;
    }

    public double evaluateSubset(BitSet subset, Instance holdOut, boolean retrain) throws Exception {
        int i;
        int numAttributes = 0;
        Instances trainCopy = null;
        Instance testCopy = null;
        if (!this.m_trainingInstances.equalHeaders(holdOut.dataset())) {
            throw new Exception("evaluateSubset : Incompatable instance types.\n" + this.m_trainingInstances.equalHeadersMsg(holdOut.dataset()));
        }
        Remove delTransform = new Remove();
        delTransform.setInvertSelection(true);
        trainCopy = new Instances(this.m_trainingInstances);
        testCopy = (Instance)holdOut.copy();
        for (i = 0; i < this.m_numAttribs; ++i) {
            if (!subset.get(i)) continue;
            ++numAttributes;
        }
        int[] featArray = new int[numAttributes + 1];
        int j = 0;
        for (i = 0; i < this.m_numAttribs; ++i) {
            if (!subset.get(i)) continue;
            featArray[j++] = i;
        }
        featArray[j] = this.m_classIndex;
        delTransform.setAttributeIndicesArray(featArray);
        delTransform.setInputFormat(trainCopy);
        if (retrain) {
            trainCopy = Filter.useFilter(trainCopy, delTransform);
            this.m_Classifier.buildClassifier(trainCopy);
        }
        delTransform.input(testCopy);
        testCopy = delTransform.output();
        double[] distrib = this.m_Classifier.distributionForInstance(testCopy);
        double pred = this.m_trainingInstances.classAttribute().isNominal() ? distrib[(int)testCopy.classValue()] : distrib[0];
        double error = this.m_trainingInstances.classAttribute().isNominal() ? 1.0 - pred : testCopy.classValue() - pred;
        return -error;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        if (this.m_trainingInstances == null) {
            text.append("\tClassifier subset evaluator has not been built yet\n");
        } else {
            text.append("\tClassifier Subset Evaluator\n");
            text.append("\tLearning scheme: " + this.getClassifier().getClass().getName() + "\n");
            text.append("\tScheme options: ");
            String[] classifierOptions = new String[]{};
            if (this.m_Classifier instanceof OptionHandler) {
                classifierOptions = ((OptionHandler)((Object)this.m_Classifier)).getOptions();
                for (int i = 0; i < classifierOptions.length; ++i) {
                    text.append(classifierOptions[i] + " ");
                }
            }
            text.append("\n");
            text.append("\tHold out/test set: ");
            if (!this.m_useTraining) {
                if (this.getHoldOutFile().getPath().startsWith("Click to set")) {
                    text.append("none\n");
                } else {
                    text.append(this.getHoldOutFile().getPath() + '\n');
                }
            } else {
                text.append("Training data\n");
            }
            if (this.m_trainingInstances.attribute(this.m_classIndex).isNumeric()) {
                text.append("\tAccuracy estimation: MAE\n");
            } else {
                text.append("\tAccuracy estimation: classification error\n");
            }
        }
        return text.toString();
    }

    protected void resetOptions() {
        this.m_trainingInstances = null;
        this.m_Evaluation = null;
        this.m_Classifier = new ZeroR();
        this.m_holdOutFile = new File("Click to set hold out or test instances");
        this.m_holdOutInstances = null;
        this.m_useTraining = false;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5928 $");
    }

    public static void main(String[] args) {
        ClassifierSubsetEval.runEvaluator(new ClassifierSubsetEval(), args);
    }
}

