/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Normalize;

public class LibSVM
extends Classifier
implements TechnicalInformationHandler {
    protected static final String CLASS_SVM = "libsvm.svm";
    protected static final String CLASS_SVMMODEL = "libsvm.svm_model";
    protected static final String CLASS_SVMPROBLEM = "libsvm.svm_problem";
    protected static final String CLASS_SVMPARAMETER = "libsvm.svm_parameter";
    protected static final String CLASS_SVMNODE = "libsvm.svm_node";
    protected static final long serialVersionUID = 14172L;
    protected Object m_Model;
    protected Filter m_Filter = null;
    protected boolean m_Normalize = false;
    public static final int SVMTYPE_C_SVC = 0;
    public static final int SVMTYPE_NU_SVC = 1;
    public static final int SVMTYPE_ONE_CLASS_SVM = 2;
    public static final int SVMTYPE_EPSILON_SVR = 3;
    public static final int SVMTYPE_NU_SVR = 4;
    public static final Tag[] TAGS_SVMTYPE = new Tag[]{new Tag(0, "C-SVC (classification)"), new Tag(1, "nu-SVC (classification)"), new Tag(2, "one-class SVM (classification)"), new Tag(3, "epsilon-SVR (regression)"), new Tag(4, "nu-SVR (regression)")};
    protected int m_SVMType = 0;
    public static final int KERNELTYPE_LINEAR = 0;
    public static final int KERNELTYPE_POLYNOMIAL = 1;
    public static final int KERNELTYPE_RBF = 2;
    public static final int KERNELTYPE_SIGMOID = 3;
    public static final Tag[] TAGS_KERNELTYPE = new Tag[]{new Tag(0, "linear: u'*v"), new Tag(1, "polynomial: (gamma*u'*v + coef0)^degree"), new Tag(2, "radial basis function: exp(-gamma*|u-v|^2)"), new Tag(3, "sigmoid: tanh(gamma*u'*v + coef0)")};
    protected int m_KernelType = 2;
    protected int m_Degree = 3;
    protected double m_Gamma = 0.0;
    protected double m_GammaActual = 0.0;
    protected double m_Coef0 = 0.0;
    protected double m_CacheSize = 40.0;
    protected double m_eps = 0.001;
    protected double m_Cost = 1.0;
    protected int[] m_WeightLabel = new int[0];
    protected double[] m_Weight = new double[0];
    protected double m_nu = 0.5;
    protected double m_Loss = 0.1;
    protected boolean m_Shrinking = true;
    protected boolean m_ProbabilityEstimates = false;
    protected static boolean m_Present = false;

    public String globalInfo() {
        return "A wrapper class for the libsvm tools (the libsvm classes, typically the jar file, need to be in the classpath to use this classifier).\nLibSVM runs faster than SMO since it uses LibSVM to build the SVM classifier.\nLibSVM allows users to experiment with One-class SVM, Regressing SVM, and nu-SVM supported by LibSVM tool. LibSVM reports many useful statistics about LibSVM classifier (e.g., confusion matrix,precision, recall, ROC score, etc.).\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.MISC);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Yasser EL-Manzalawy");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2005");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "WLSVM");
        technicalInformation.setValue(TechnicalInformation.Field.NOTE, "LibSVM was originally developed as 'WLSVM'");
        technicalInformation.setValue(TechnicalInformation.Field.URL, "http://www.cs.iastate.edu/~yasser/wlsvm/");
        technicalInformation.setValue(TechnicalInformation.Field.NOTE, "You don't need to include the WLSVM package in the CLASSPATH");
        TechnicalInformation technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.MISC);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "Chih-Chung Chang and Chih-Jen Lin");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "LIBSVM - A Library for Support Vector Machines");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "2001");
        technicalInformation2.setValue(TechnicalInformation.Field.URL, "http://www.csie.ntu.edu.tw/~cjlin/libsvm/");
        technicalInformation2.setValue(TechnicalInformation.Field.NOTE, "The Weka classifier works with version 2.82 of LIBSVM");
        return technicalInformation;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tSet type of SVM (default: 0)\n\t\t 0 = C-SVC\n\t\t 1 = nu-SVC\n\t\t 2 = one-class SVM\n\t\t 3 = epsilon-SVR\n\t\t 4 = nu-SVR", "S", 1, "-S <int>"));
        vector.addElement(new Option("\tSet type of kernel function (default: 2)\n\t\t 0 = linear: u'*v\n\t\t 1 = polynomial: (gamma*u'*v + coef0)^degree\n\t\t 2 = radial basis function: exp(-gamma*|u-v|^2)\n\t\t 3 = sigmoid: tanh(gamma*u'*v + coef0)", "K", 1, "-K <int>"));
        vector.addElement(new Option("\tSet degree in kernel function (default: 3)", "D", 1, "-D <int>"));
        vector.addElement(new Option("\tSet gamma in kernel function (default: 1/k)", "G", 1, "-G <double>"));
        vector.addElement(new Option("\tSet coef0 in kernel function (default: 0)", "R", 1, "-R <double>"));
        vector.addElement(new Option("\tSet the parameter C of C-SVC, epsilon-SVR, and nu-SVR\n\t (default: 1)", "C", 1, "-C <double>"));
        vector.addElement(new Option("\tSet the parameter nu of nu-SVC, one-class SVM, and nu-SVR\n\t (default: 0.5)", "N", 1, "-N <double>"));
        vector.addElement(new Option("\tTurns on normalization of input data (default: off)", "Z", 0, "-Z"));
        vector.addElement(new Option("\tSet the epsilon in loss function of epsilon-SVR (default: 0.1)", "P", 1, "-P <double>"));
        vector.addElement(new Option("\tSet cache memory size in MB (default: 40)", "M", 1, "-M <double>"));
        vector.addElement(new Option("\tSet tolerance of termination criterion (default: 0.001)", "E", 1, "-E <double>"));
        vector.addElement(new Option("\tTurns the shrinking heuristics off (default: on)", "H", 0, "-H"));
        vector.addElement(new Option("\tSet the parameters C of class i to weight[i]*C, for C-SVC\n\t (default: 1)", "W", 1, "-W <double>"));
        vector.addElement(new Option("\tTrains a SVC model instead of a SVR one (default: SVR)", "B", 0, "-B"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('S', stringArray);
        if (string.length() != 0) {
            this.setSVMType(new SelectedTag(Integer.parseInt(string), TAGS_SVMTYPE));
        } else {
            this.setSVMType(new SelectedTag(0, TAGS_SVMTYPE));
        }
        string = Utils.getOption('K', stringArray);
        if (string.length() != 0) {
            this.setKernelType(new SelectedTag(Integer.parseInt(string), TAGS_KERNELTYPE));
        } else {
            this.setKernelType(new SelectedTag(2, TAGS_KERNELTYPE));
        }
        string = Utils.getOption('D', stringArray);
        if (string.length() != 0) {
            this.setDegree(Integer.parseInt(string));
        } else {
            this.setDegree(3);
        }
        string = Utils.getOption('G', stringArray);
        if (string.length() != 0) {
            this.setGamma(Double.parseDouble(string));
        } else {
            this.setGamma(0.0);
        }
        string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            this.setCoef0(Double.parseDouble(string));
        } else {
            this.setCoef0(0.0);
        }
        string = Utils.getOption('N', stringArray);
        if (string.length() != 0) {
            this.setNu(Double.parseDouble(string));
        } else {
            this.setNu(0.5);
        }
        string = Utils.getOption('M', stringArray);
        if (string.length() != 0) {
            this.setCacheSize(Double.parseDouble(string));
        } else {
            this.setCacheSize(40.0);
        }
        string = Utils.getOption('C', stringArray);
        if (string.length() != 0) {
            this.setCost(Double.parseDouble(string));
        } else {
            this.setCost(1.0);
        }
        string = Utils.getOption('E', stringArray);
        if (string.length() != 0) {
            this.setEps(Double.parseDouble(string));
        } else {
            this.setEps(0.001);
        }
        this.setNormalize(Utils.getFlag('Z', stringArray));
        string = Utils.getOption('P', stringArray);
        if (string.length() != 0) {
            this.setLoss(Double.parseDouble(string));
        } else {
            this.setLoss(0.1);
        }
        this.setShrinking(!Utils.getFlag('H', stringArray));
        this.setWeights(Utils.getOption('W', stringArray));
        this.setProbabilityEstimates(Utils.getFlag('B', stringArray));
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-S");
        vector.add("" + this.m_SVMType);
        vector.add("-K");
        vector.add("" + this.m_KernelType);
        vector.add("-D");
        vector.add("" + this.getDegree());
        vector.add("-G");
        vector.add("" + this.getGamma());
        vector.add("-R");
        vector.add("" + this.getCoef0());
        vector.add("-N");
        vector.add("" + this.getNu());
        vector.add("-M");
        vector.add("" + this.getCacheSize());
        vector.add("-C");
        vector.add("" + this.getCost());
        vector.add("-E");
        vector.add("" + this.getEps());
        vector.add("-P");
        vector.add("" + this.getLoss());
        if (!this.getShrinking()) {
            vector.add("-H");
        }
        if (this.getNormalize()) {
            vector.add("-Z");
        }
        if (this.getWeights().length() != 0) {
            vector.add("-W");
            vector.add("" + this.getWeights());
        }
        if (this.getProbabilityEstimates()) {
            vector.add("-B");
        }
        return vector.toArray(new String[vector.size()]);
    }

    public static boolean isPresent() {
        return m_Present;
    }

    public void setSVMType(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_SVMTYPE) {
            this.m_SVMType = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getSVMType() {
        return new SelectedTag(this.m_SVMType, TAGS_SVMTYPE);
    }

    public String SVMTypeTipText() {
        return "The type of SVM to use.";
    }

    public void setKernelType(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_KERNELTYPE) {
            this.m_KernelType = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getKernelType() {
        return new SelectedTag(this.m_KernelType, TAGS_KERNELTYPE);
    }

    public String kernelTypeTipText() {
        return "The type of kernel to use";
    }

    public void setDegree(int n) {
        this.m_Degree = n;
    }

    public int getDegree() {
        return this.m_Degree;
    }

    public String degreeTipText() {
        return "The degree of the kernel.";
    }

    public void setGamma(double d) {
        this.m_Gamma = d;
    }

    public double getGamma() {
        return this.m_Gamma;
    }

    public String gammaTipText() {
        return "The gamma to use, if 0 then 1/max_index is used.";
    }

    public void setCoef0(double d) {
        this.m_Coef0 = d;
    }

    public double getCoef0() {
        return this.m_Coef0;
    }

    public String coef0TipText() {
        return "The coefficient to use.";
    }

    public void setNu(double d) {
        this.m_nu = d;
    }

    public double getNu() {
        return this.m_nu;
    }

    public String nuTipText() {
        return "The value of nu for nu-SVC, one-class SVM and nu-SVR.";
    }

    public void setCacheSize(double d) {
        this.m_CacheSize = d;
    }

    public double getCacheSize() {
        return this.m_CacheSize;
    }

    public String cacheSizeTipText() {
        return "The cache size in MB.";
    }

    public void setCost(double d) {
        this.m_Cost = d;
    }

    public double getCost() {
        return this.m_Cost;
    }

    public String costTipText() {
        return "The cost parameter C for C-SVC, epsilon-SVR and nu-SVR.";
    }

    public void setEps(double d) {
        this.m_eps = d;
    }

    public double getEps() {
        return this.m_eps;
    }

    public String epsTipText() {
        return "The tolerance of the termination criterion.";
    }

    public void setLoss(double d) {
        this.m_Loss = d;
    }

    public double getLoss() {
        return this.m_Loss;
    }

    public String lossTipText() {
        return "The epsilon for the loss function in epsilon-SVR.";
    }

    public void setShrinking(boolean bl) {
        this.m_Shrinking = bl;
    }

    public boolean getShrinking() {
        return this.m_Shrinking;
    }

    public String shrinkingTipText() {
        return "Whether to use the shrinking heuristic.";
    }

    public void setNormalize(boolean bl) {
        this.m_Normalize = bl;
    }

    public boolean getNormalize() {
        return this.m_Normalize;
    }

    public String normalizeTipText() {
        return "Whether to normalize the data.";
    }

    public void setWeights(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        this.m_Weight = new double[stringTokenizer.countTokens()];
        this.m_WeightLabel = new int[stringTokenizer.countTokens()];
        if (this.m_Weight.length == 0) {
            System.out.println("Zero Weights processed. Default weights will be used");
        }
        for (int i = 0; i < this.m_Weight.length; ++i) {
            this.m_Weight[i] = Double.parseDouble(stringTokenizer.nextToken());
            this.m_WeightLabel[i] = i;
        }
    }

    public String getWeights() {
        String string = "";
        for (int i = 0; i < this.m_Weight.length; ++i) {
            if (i > 0) {
                string = string + " ";
            }
            string = string + Double.toString(this.m_Weight[i]);
        }
        return string;
    }

    public String weightsTipText() {
        return "The weights to use for the classes, if empty 1 is used by default.";
    }

    public void setProbabilityEstimates(boolean bl) {
        this.m_ProbabilityEstimates = bl;
    }

    public boolean getProbabilityEstimates() {
        return this.m_ProbabilityEstimates;
    }

    public String probabilityEstimatesTipText() {
        return "Whether to generate probability estimates instead of -1/+1 for classification problems.";
    }

    protected void setField(Object object, String string, Object object2) {
        try {
            Field field = object.getClass().getField(string);
            field.set(object, object2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void setField(Object object, String string, int n, Object object2) {
        try {
            Field field = object.getClass().getField(string);
            Array.set(field.get(object), n, object2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected Object getField(Object object, String string) {
        Object object2;
        try {
            Field field = object.getClass().getField(string);
            object2 = field.get(object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            object2 = null;
        }
        return object2;
    }

    protected void newArray(Object object, String string, Class clazz, int n) {
        this.newArray(object, string, clazz, new int[]{n});
    }

    protected void newArray(Object object, String string, Class clazz, int[] nArray) {
        try {
            Field field = object.getClass().getField(string);
            field.set(object, Array.newInstance(clazz, nArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected Object invokeMethod(Object object, String string, Class[] classArray, Object[] objectArray) {
        Object object2 = null;
        try {
            Method method = object.getClass().getMethod(string, classArray);
            object2 = method.invoke(object, objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            object2 = null;
        }
        return object2;
    }

    protected Object getParameters() {
        Object obj;
        try {
            obj = Class.forName(CLASS_SVMPARAMETER).newInstance();
            this.setField(obj, "svm_type", new Integer(this.m_SVMType));
            this.setField(obj, "kernel_type", new Integer(this.m_KernelType));
            this.setField(obj, "degree", new Integer(this.m_Degree));
            this.setField(obj, "gamma", new Double(this.m_GammaActual));
            this.setField(obj, "coef0", new Double(this.m_Coef0));
            this.setField(obj, "nu", new Double(this.m_nu));
            this.setField(obj, "cache_size", new Double(this.m_CacheSize));
            this.setField(obj, "C", new Double(this.m_Cost));
            this.setField(obj, "eps", new Double(this.m_eps));
            this.setField(obj, "p", new Double(this.m_Loss));
            this.setField(obj, "shrinking", new Integer(this.m_Shrinking ? 1 : 0));
            this.setField(obj, "nr_weight", new Integer(this.m_Weight.length));
            this.setField(obj, "probability", new Integer(this.m_ProbabilityEstimates ? 1 : 0));
            this.newArray(obj, "weight", Double.TYPE, this.m_Weight.length);
            this.newArray(obj, "weight_label", Integer.TYPE, this.m_Weight.length);
            for (int i = 0; i < this.m_Weight.length; ++i) {
                this.setField(obj, "weight", i, new Double(this.m_Weight[i]));
                this.setField(obj, "weight_label", i, new Integer(this.m_WeightLabel[i]));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            obj = null;
        }
        return obj;
    }

    protected Object getProblem(Vector vector, Vector vector2) {
        Object obj;
        try {
            int n;
            obj = Class.forName(CLASS_SVMPROBLEM).newInstance();
            this.setField(obj, "l", new Integer(vector2.size()));
            this.newArray(obj, "x", Class.forName(CLASS_SVMNODE), new int[]{vector2.size(), 0});
            for (n = 0; n < vector2.size(); ++n) {
                this.setField(obj, "x", n, vector.elementAt(n));
            }
            this.newArray(obj, "y", Double.TYPE, vector2.size());
            for (n = 0; n < vector2.size(); ++n) {
                this.setField(obj, "y", n, vector2.elementAt(n));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            obj = null;
        }
        return obj;
    }

    protected Object instanceToArray(Instance instance) throws Exception {
        int n;
        int n2 = 0;
        for (n = 0; n < instance.numAttributes(); ++n) {
            if (n == instance.classIndex() || instance.value(n) == 0.0) continue;
            ++n2;
        }
        Object object = Array.newInstance(Class.forName(CLASS_SVMNODE), n2);
        int n3 = 0;
        for (n = 0; n < instance.numAttributes(); ++n) {
            if (n == instance.classIndex() || instance.value(n) == 0.0) continue;
            Array.set(object, n3, Class.forName(CLASS_SVMNODE).newInstance());
            this.setField(Array.get(object, n3), "index", new Integer(n + 1));
            this.setField(Array.get(object, n3), "value", new Double(instance.value(n)));
            ++n3;
        }
        return object;
    }

    public double classifyInstance(Instance instance) throws Exception {
        if (this.m_Filter != null) {
            this.m_Filter.input(instance);
            this.m_Filter.batchFinished();
            instance = this.m_Filter.output();
        }
        Object object = this.instanceToArray(instance);
        double d = (Double)this.invokeMethod(Class.forName(CLASS_SVM).newInstance(), "svm_predict", new Class[]{Class.forName(CLASS_SVMMODEL), Array.newInstance(Class.forName(CLASS_SVMNODE), Array.getLength(object)).getClass()}, new Object[]{this.m_Model, object});
        return d;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        int[] nArray = new int[instance.numClasses()];
        double[] dArray = null;
        if (this.m_ProbabilityEstimates) {
            if (this.m_SVMType == 3 || this.m_SVMType == 4) {
                throw new Exception("Do not use distributionForInstance for regression models!");
            }
            this.invokeMethod(Class.forName(CLASS_SVM).newInstance(), "svm_get_labels", new Class[]{Class.forName(CLASS_SVMMODEL), Array.newInstance(Integer.TYPE, instance.numClasses()).getClass()}, new Object[]{this.m_Model, nArray});
            dArray = new double[instance.numClasses()];
        }
        if (this.m_Filter != null) {
            this.m_Filter.input(instance);
            this.m_Filter.batchFinished();
            instance = this.m_Filter.output();
        }
        Object object = this.instanceToArray(instance);
        double[] dArray2 = new double[instance.numClasses()];
        if (this.m_ProbabilityEstimates && (this.m_SVMType == 0 || this.m_SVMType == 1)) {
            double d = (Double)this.invokeMethod(Class.forName(CLASS_SVM).newInstance(), "svm_predict_probability", new Class[]{Class.forName(CLASS_SVMMODEL), Array.newInstance(Class.forName(CLASS_SVMNODE), Array.getLength(object)).getClass(), Array.newInstance(Double.TYPE, dArray.length).getClass()}, new Object[]{this.m_Model, object, dArray});
            for (int i = 0; i < dArray.length; ++i) {
                dArray2[nArray[i]] = dArray[i];
            }
        } else {
            double d = (Double)this.invokeMethod(Class.forName(CLASS_SVM).newInstance(), "svm_predict", new Class[]{Class.forName(CLASS_SVMMODEL), Array.newInstance(Class.forName(CLASS_SVMNODE), Array.getLength(object)).getClass()}, new Object[]{this.m_Model, object});
            if (instance.classAttribute().isNominal()) {
                dArray2[(int)d] = 1.0;
            } else {
                dArray2[0] = d;
            }
        }
        return dArray2;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        switch (this.m_SVMType) {
            case 0: 
            case 1: {
                capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
                break;
            }
            case 2: {
                capabilities.enable(Capabilities.Capability.UNARY_CLASS);
                break;
            }
            case 3: 
            case 4: {
                capabilities.enable(Capabilities.Capability.NUMERIC_CLASS);
                capabilities.enable(Capabilities.Capability.DATE_CLASS);
                break;
            }
            default: {
                throw new IllegalArgumentException("SVMType " + this.m_SVMType + " is not supported!");
            }
        }
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        if (!LibSVM.isPresent()) {
            throw new Exception("libsvm classes not in CLASSPATH!");
        }
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        if (this.getNormalize()) {
            this.m_Filter = new Normalize();
            this.m_Filter.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_Filter);
        }
        Vector<Double> vector = new Vector<Double>();
        Vector<Object> vector2 = new Vector<Object>();
        int n = 0;
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            Object object = this.instanceToArray(instance);
            int n2 = Array.getLength(object);
            if (n2 > 0) {
                n = Math.max(n, (Integer)this.getField(Array.get(object, n2 - 1), "index"));
            }
            vector2.addElement(object);
            vector.addElement(new Double(instance.classValue()));
        }
        this.m_GammaActual = this.getGamma() == 0.0 ? 1.0 / (double)n : this.m_Gamma;
        String string = (String)this.invokeMethod(Class.forName(CLASS_SVM).newInstance(), "svm_check_parameter", new Class[]{Class.forName(CLASS_SVMPROBLEM), Class.forName(CLASS_SVMPARAMETER)}, new Object[]{this.getProblem(vector2, vector), this.getParameters()});
        if (string != null) {
            throw new Exception("Error: " + string);
        }
        this.m_Model = this.invokeMethod(Class.forName(CLASS_SVM).newInstance(), "svm_train", new Class[]{Class.forName(CLASS_SVMPROBLEM), Class.forName(CLASS_SVMPARAMETER)}, new Object[]{this.getProblem(vector2, vector), this.getParameters()});
    }

    public String toString() {
        return "LibSVM wrapper, original code by Yasser EL-Manzalawy (= WLSVM)";
    }

    public static void main(String[] stringArray) {
        LibSVM.runClassifier(new LibSVM(), stringArray);
    }

    static {
        try {
            Class.forName(CLASS_SVM);
            m_Present = true;
        }
        catch (Exception exception) {
            m_Present = false;
        }
    }
}

