/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.util.Enumeration;
import java.util.Vector;
import weka.clusterers.DensityBasedClusterer;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Randomizable;
import weka.core.Utils;

public abstract class RandomizableDensityBasedClusterer
extends DensityBasedClusterer
implements OptionHandler,
Randomizable {
    private static final long serialVersionUID = -5325270357918932849L;
    protected int m_SeedDefault;
    protected int m_Seed;

    public RandomizableDensityBasedClusterer() {
        this.m_Seed = this.m_SeedDefault = 1;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tRandom number seed.\n\t(default " + this.m_SeedDefault + ")", "S", 1, "-S <num>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('S', stringArray);
        if (string.length() != 0) {
            this.setSeed(Integer.parseInt(string));
        } else {
            this.setSeed(this.m_SeedDefault);
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-S");
        vector.add("" + this.getSeed());
        return vector.toArray(new String[vector.size()]);
    }

    public String seedTipText() {
        return "The random number seed to be used.";
    }

    public void setSeed(int n) {
        this.m_Seed = n;
    }

    public int getSeed() {
        return this.m_Seed;
    }
}

