/*
 * Decompiled with CFR 0.152.
 */
package weka.core.parser.JFlex;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import weka.core.parser.JFlex.DFA;
import weka.core.parser.JFlex.Emitter;
import weka.core.parser.JFlex.ErrorMessages;
import weka.core.parser.JFlex.GeneratorException;
import weka.core.parser.JFlex.LexParse;
import weka.core.parser.JFlex.LexScan;
import weka.core.parser.JFlex.MacroException;
import weka.core.parser.JFlex.NFA;
import weka.core.parser.JFlex.Options;
import weka.core.parser.JFlex.Out;
import weka.core.parser.JFlex.ScannerException;
import weka.core.parser.JFlex.SilentExit;
import weka.core.parser.JFlex.Timer;

public class Main {
    public static final String version = "1.4.1";

    public static void generate(File file) {
        Out.resetCounters();
        Timer timer = new Timer();
        Timer timer2 = new Timer();
        LexScan lexScan = null;
        LexParse lexParse = null;
        FileReader fileReader = null;
        timer.start();
        try {
            Out.println(ErrorMessages.READING, file.toString());
            fileReader = new FileReader(file);
            lexScan = new LexScan(fileReader);
            lexScan.setFile(file);
            lexParse = new LexParse(lexScan);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Out.error(ErrorMessages.CANNOT_OPEN, file.toString());
            throw new GeneratorException();
        }
        try {
            NFA nFA = (NFA)lexParse.parse().value;
            Out.checkErrors();
            if (Options.dump) {
                Out.dump(ErrorMessages.get(ErrorMessages.NFA_IS) + Out.NL + nFA + Out.NL);
            }
            if (Options.dot) {
                nFA.writeDot(Emitter.normalize("nfa.dot", null));
            }
            Out.println(ErrorMessages.NFA_STATES, nFA.numStates);
            timer2.start();
            DFA dFA = nFA.getDFA();
            timer2.stop();
            Out.time(ErrorMessages.DFA_TOOK, timer2);
            dFA.checkActions(lexScan, lexParse);
            nFA = null;
            if (Options.dump) {
                Out.dump(ErrorMessages.get(ErrorMessages.DFA_IS) + Out.NL + dFA + Out.NL);
            }
            if (Options.dot) {
                dFA.writeDot(Emitter.normalize("dfa-big.dot", null));
            }
            timer2.start();
            dFA.minimize();
            timer2.stop();
            Out.time(ErrorMessages.MIN_TOOK, timer2);
            if (Options.dump) {
                Out.dump(ErrorMessages.get(ErrorMessages.MIN_DFA_IS) + Out.NL + dFA);
            }
            if (Options.dot) {
                dFA.writeDot(Emitter.normalize("dfa-min.dot", null));
            }
            timer2.start();
            Emitter emitter = new Emitter(file, lexParse, dFA);
            emitter.emit();
            timer2.stop();
            Out.time(ErrorMessages.WRITE_TOOK, timer2);
            timer.stop();
            Out.time(ErrorMessages.TOTAL_TIME, timer);
        }
        catch (ScannerException scannerException) {
            Out.error(scannerException.file, scannerException.message, scannerException.line, scannerException.column);
            throw new GeneratorException();
        }
        catch (MacroException macroException) {
            Out.error(macroException.getMessage());
            throw new GeneratorException();
        }
        catch (IOException iOException) {
            Out.error(ErrorMessages.IO_ERROR, iOException.toString());
            throw new GeneratorException();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Out.error(ErrorMessages.OUT_OF_MEMORY);
            throw new GeneratorException();
        }
        catch (GeneratorException generatorException) {
            throw new GeneratorException();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new GeneratorException();
        }
    }

    public static Vector parseOptions(String[] stringArray) throws SilentExit {
        Vector<File> vector = new Vector<File>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-d") || stringArray[i].equals("--outdir")) {
                if (++i >= stringArray.length) {
                    Out.error(ErrorMessages.NO_DIRECTORY);
                    throw new GeneratorException();
                }
                Options.setDir(stringArray[i]);
                continue;
            }
            if (stringArray[i].equals("--skel") || stringArray[i].equals("-skel")) {
                if (++i >= stringArray.length) {
                    Out.error(ErrorMessages.NO_SKEL_FILE);
                    throw new GeneratorException();
                }
                Options.setSkeleton(new File(stringArray[i]));
                continue;
            }
            if (stringArray[i].equals("-jlex") || stringArray[i].equals("--jlex")) {
                Options.jlex = true;
                continue;
            }
            if (stringArray[i].equals("-v") || stringArray[i].equals("--verbose") || stringArray[i].equals("-verbose")) {
                Options.verbose = true;
                Options.progress = true;
                continue;
            }
            if (stringArray[i].equals("-q") || stringArray[i].equals("--quiet") || stringArray[i].equals("-quiet")) {
                Options.verbose = false;
                Options.progress = false;
                continue;
            }
            if (stringArray[i].equals("--dump") || stringArray[i].equals("-dump")) {
                Options.dump = true;
                continue;
            }
            if (stringArray[i].equals("--time") || stringArray[i].equals("-time")) {
                Options.time = true;
                continue;
            }
            if (stringArray[i].equals("--version") || stringArray[i].equals("-version")) {
                Out.println(ErrorMessages.THIS_IS_JFLEX, version);
                throw new SilentExit();
            }
            if (stringArray[i].equals("--dot") || stringArray[i].equals("-dot")) {
                Options.dot = true;
                continue;
            }
            if (stringArray[i].equals("--help") || stringArray[i].equals("-h") || stringArray[i].equals("/h")) {
                Main.printUsage();
                throw new SilentExit();
            }
            if (stringArray[i].equals("--info") || stringArray[i].equals("-info")) {
                Out.printSystemInfo();
                throw new SilentExit();
            }
            if (stringArray[i].equals("--nomin") || stringArray[i].equals("-nomin")) {
                Options.no_minimize = true;
                continue;
            }
            if (stringArray[i].equals("--pack") || stringArray[i].equals("-pack")) {
                Options.gen_method = 0;
                continue;
            }
            if (stringArray[i].equals("--table") || stringArray[i].equals("-table")) {
                Options.gen_method = 1;
                continue;
            }
            if (stringArray[i].equals("--switch") || stringArray[i].equals("-switch")) {
                Options.gen_method = 2;
                continue;
            }
            if (stringArray[i].equals("--nobak") || stringArray[i].equals("-nobak")) {
                Options.no_backup = true;
                continue;
            }
            if (stringArray[i].startsWith("-")) {
                Out.error(ErrorMessages.UNKNOWN_COMMANDLINE, stringArray[i]);
                Main.printUsage();
                throw new SilentExit();
            }
            File file = new File(stringArray[i]);
            if (file.isFile() && file.canRead()) {
                vector.addElement(file);
                continue;
            }
            Out.error("Sorry, couldn't open \"" + file + "\"");
            throw new GeneratorException();
        }
        return vector;
    }

    public static void printUsage() {
        Out.println("");
        Out.println("Usage: jflex <options> <input-files>");
        Out.println("");
        Out.println("Where <options> can be one or more of");
        Out.println("-d <directory>   write generated file to <directory>");
        Out.println("--skel <file>    use external skeleton <file>");
        Out.println("--switch");
        Out.println("--table");
        Out.println("--pack           set default code generation method");
        Out.println("--jlex           strict JLex compatibility");
        Out.println("--nomin          skip minimization step");
        Out.println("--nobak          don't create backup files");
        Out.println("--dump           display transition tables");
        Out.println("--dot            write graphviz .dot files for the generated automata (alpha)");
        Out.println("--verbose");
        Out.println("-v               display generation progress messages (default)");
        Out.println("--quiet");
        Out.println("-q               display errors only");
        Out.println("--time           display generation time statistics");
        Out.println("--version        print the version number of this copy of jflex");
        Out.println("--info           print system + JDK information");
        Out.println("--help");
        Out.println("-h               print this message");
        Out.println("");
        Out.println(ErrorMessages.THIS_IS_JFLEX, version);
        Out.println("Have a nice day!");
    }

    public static void generate(String[] stringArray) throws SilentExit {
        Vector vector = Main.parseOptions(stringArray);
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                Main.generate((File)vector.elementAt(i));
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            Main.generate(stringArray);
        }
        catch (GeneratorException generatorException) {
            Out.statistics();
            System.exit(1);
        }
        catch (SilentExit silentExit) {
            System.exit(1);
        }
    }
}

