% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rwtbl_helpers.R
\name{rwtbl_slot_names}
\alias{rwtbl_slot_names}
\title{List the slot names in a tbl_df}
\usage{
rwtbl_slot_names(rwtbl)
}
\arguments{
\item{rwtbl}{A \code{tbl_df} object with RiverWare output. Must contain the
\code{ObjectSlot} column.}
}
\description{
\code{rwtbl_slot_names()} lists all of the slot names found in a \code{tbl_df} object
containing RiverWare output data.
}
\details{
Given a \code{tbl_df} object that is returned by \code{\link[=rdf_to_rwtbl]{rdf_to_rwtbl()}} or
\code{\link[=read_rw_csv]{read_rw_csv()}}, return all of the Object.Slot names found in the data
frame. These are the unique full slot names found in the \code{ObjectSlot}
column.
}
\examples{
rwtbl <- rdf_to_rwtbl(keyRdf)
rwtbl_slot_names(rwtbl)

}
\seealso{
\code{\link[=rdf_to_rwtbl]{rdf_to_rwtbl()}}, \code{\link[=read_rw_csv]{read_rw_csv()}}
}
