% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ASKAT.region.R
\name{ASKAT.region}
\alias{ASKAT.region}
\title{Run the ASKAT method on a genomic region defined by a start
    and a stop base pair coordinate}
\usage{
ASKAT.region(y = NULL, X = NULL, Phi = NULL, type = "bed",
  filename = NULL, map = NULL, chr = 0, startpos = 0, endpos = 0,
  regionname = NULL, U = NULL, S = NULL, RH.Null = NULL,
  weights = NULL)
}
\arguments{
\item{y}{vector of phenotype data (one entry per individual), of
length \eqn{n}.}

\item{X}{matrix of covariates including intercept (dimension:
\eqn{n \times p}, with \eqn{p} the number of covariates)}

\item{Phi}{Relationship matrix (i.e. twice the kinship matrix); an
\eqn{n \times n} square symmetric positive-definite matrix.}

\item{type}{character, \code{'ped'}, \code{'bed'} (default) or
\code{'shapeit-haps'} format of input file containing haplotype
data}

\item{filename}{character, path to input file containing haplotype data}

\item{map}{object, data.frame contains 3 columns: rsID, chromosome,
position in bp as output by e.g. \code{\link{readMapFile}}.}

\item{chr}{character, chromosome number (basically from 1 to 22 as used by
\href{http://pngu.mgh.harvard.edu/~purcell/plink/data.shtml#ped}{Plink}),
on which the region of interest is located}

\item{startpos}{numeric, start position (in bp, base pairs) of the
region of interest (default: 0)}

\item{endpos}{numeric, end position (in bp, base pairs) of the
region of interest (default: 0)}

\item{regionname}{(character) Name of the region/gene on which you
are running the association test. This name is used in the
output of this function and can be used to distinguish
different regions if this function is run multiple times.}

\item{U}{(optional) Matrix of Eigenvectors of the relationship matrix
obtained from spectral decomposition of the relationship matrix:
\eqn{\Phi = U S U^T}. If this parameter is not given, it will
be computed, so when running this function for many regions
time can be saved by specifying not only \code{Phi}, but also
\code{S} and \code{U}.}

\item{S}{(optional) Matrix of Eigenvalues of the relationship matrix
obtained from spectral decomposition of the relationship matrix:
\eqn{\Phi = U S U^T}. If this parameter is not given, it will
be computed, so when running this function for many regions,
time can be saved by specifying not only \code{Phi}, but also
\code{S} and \code{U}.}

\item{RH.Null}{(optional) output of \code{\link{Estim.H0.ASKAT}}
function. In analyses of many regions, it is not necessary to calculate the the null
hypothesis for each region. One estimation per trait is
enough.}

\item{weights}{optional numeric vector of genotype weights. If
this option is not specified, the beta distribution is used
for weighting the variants, with each weight given by
\eqn{w_i = dbeta(f_i, 1, 25)^2}, with \eqn{f_i} the minor
allele frequency (MAF) of variant \eqn{i}. This default is the
same as used by the
\href{https://cran.r-project.org/package=SKAT}{\code{SKAT}
package}. This vector is used as the diagonal of the
\eqn{m \times m} matrix \eqn{W}, with \eqn{m} the number of
variants.}
}
\value{
A data frame containing the results of the association
    test. The data frame contains the following columns:
    \itemize{
    \item \code{Score.Test}: the score of the given association test
    \item \code{P.value}: the p-value of the association test
    \item \code{N.Markers}: the number of markers in the region
    \item \code{regionname}: Name of the region/gene on which you
    are running the association test
    }
}
\description{
Runs the ASKAT method on a given genomic region
}
\author{
Lennart C. Karssen, Sodbo Sharapov
}

