% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RSocrata.R
\name{read.socrata}
\alias{read.socrata}
\title{Get a full Socrata data set as an R data frame}
\usage{
read.socrata(
  url,
  app_token = NULL,
  email = NULL,
  password = NULL,
  stringsAsFactors = FALSE
)
}
\arguments{
\item{url}{- A Socrata resource URL, 
or a Socrata "human-friendly" URL, 
or Socrata Open Data Application Program Interface (SODA) query 
requesting a comma-separated download format (.csv suffix), 
May include SoQL parameters, 
but is assumed to not include a SODA offset parameter}

\item{app_token}{- a string; SODA API token used to query the data 
portal \url{https://dev.socrata.com/consumers/getting-started.html}}

\item{email}{- Optional. The email to the Socrata account with read access to the dataset}

\item{password}{- Optional. The password associated with the email to the Socrata account}

\item{stringsAsFactors}{- Optional. Should character columns be converted to factor (TRUE or FALSE)?}
}
\value{
an R data frame with POSIX dates
}
\description{
Manages throttling and POSIX date-time conversions
}
\examples{
\dontrun{
# Human-readable URL:
url <- "https://soda.demo.socrata.com/dataset/USGS-Earthquakes-for-2012-11-01-API/4334-bgaj"
df <- read.socrata(url)
# SoDA URL:
df <- read.socrata("https://soda.demo.socrata.com/resource/4334-bgaj.csv")
# Download private dataset
socrataEmail <- Sys.getenv("SOCRATA_EMAIL", "mark.silverberg+soda.demo@socrata.com")
socrataPassword <- Sys.getenv("SOCRATA_PASSWORD", "7vFDsGFDUG")
privateResourceToReadCsvUrl <- "https://soda.demo.socrata.com/resource/a9g2-feh2.csv" # dataset
read.socrata(url = privateResourceToReadCsvUrl, email = socrataEmail, password = socrataPassword)
# Using an API key to read datasets (reduces throttling)
token <- "ew2rEMuESuzWPqMkyPfOSGJgE"
df <- read.socrata("https://soda.demo.socrata.com/resource/4334-bgaj.csv", 
                   app_token = token)
nrow(df)
closeAllConnections()
}
}
\author{
Hugh J. Devlin, Ph. D. \email{Hugh.Devlin@cityofchicago.org}
}
