\name{rsaga.hillshade}
\alias{rsaga.hillshade}
\title{Analytical hillshading
Analytical hillshading calculation.}
\usage{
  rsaga.hillshade(in.dem, out.grid, method = "standard",
    azimuth = 315, declination = 45, exaggeration = 4, ...)
}
\arguments{
  \item{in.dem}{Input digital elevation model (DEM) as SAGA
  grid file (default extension: \code{.sgrd}).}

  \item{out.grid}{Output hillshading grid (SAGA grid file).
  Existing files will be overwritten!}

  \item{method}{Available choices (character or numeric):
  \code{"standard"} (or \code{0} - default),
  \code{"max90deg.standard"} (\code{1}),
  \code{"combined.shading"} (\code{2}),
  \code{"ray.tracing"} (\code{3}). See Details.}

  \item{azimuth}{Direction of the light source, measured in
  degree clockwise from the north direction; default 315,
  i.e. northwest.}

  \item{declination}{Declination of the light source,
  measured in degree above the horizon (default 45).}

  \item{exaggeration}{Vertical exaggeration of elevation
  (default: 4). The terrain exaggeration factor allows to
  increase the shading contrasts in flat areas.}

  \item{...}{Optional arguments to be passed to
  \code{\link{rsaga.geoprocessor}}, including the
  \code{env} RSAGA geoprocessing environment.}
}
\value{
  The type of object returned depends on the \code{intern}
  argument passed to the \code{\link{rsaga.geoprocessor}}.
  For \code{intern=FALSE} it is a numerical error code (0:
  success), or otherwise (default) a character vector with
  the module's console output.
}
\description{
  Analytical hillshading Analytical hillshading
  calculation.
}
\details{
  The Analytical Hillshading algorithm is based on the
  angle between the surface and the incoming light beams,
  measured in radians.
}
\note{
  While the default azimuth of 315 degree (northwest) is
  not physically meaningful on the northern hemisphere, a
  northwesterly light source is required to properly depict
  relief in hillshading images. Physically correct
  southerly light sources results a hillshade that would be
  considered by most people as inverted: hills look like
  depressions, mountain chains like troughs.
}
\examples{
\dontrun{rsaga.hillshade("dem.sgrd","hillshade")}
}
\author{
  Alexander Brenning (R interface), Olaf Conrad (SAGA
  module)
}
\seealso{
  \code{\link{rsaga.solar.radiation}},
  \code{\link{rsaga.insolation}}
}
\keyword{interface}
\keyword{spatial}

