% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstimatorES.R
\name{EstimatorSE}
\alias{EstimatorSE}
\title{Wrapper Function for Standard Errors Estimates Functions}
\usage{
EstimatorSE(data, estimator.fun = c("Mean", "SD", "VaR", "ES", "SR",
  "SoR", "ESratio", "VaRratio", "SoR", "LPM", "OmegaRatio", "SemiSD",
  "RachevRatio"), se.method = c("IFiid", "IFcor", "IFcorAdapt",
  "IFcorPW", "BOOTiid", "BOOTcor"), cleanOutliers = FALSE,
  fitting.method = c("Exponential", "Gamma")[1], a = 0.3, b = 0.7,
  ...)
}
\arguments{
\item{data}{Data of returns for one or multiple assets or portfolios.}

\item{estimator.fun}{Risk or performance measure to compute estimates of standard errors.}

\item{se.method}{A character string indicating which method should be used to compute
the standard error of the estimated standard deviation. One of:
\code{"IFiid"}, \code{"IFcor"}, \code{"IFcorAdapt"}, \code{"IFcorPW"},
\code{"BOOTiid"}, \code{"BOOTcor"}, or \code{"none"}.}

\item{cleanOutliers}{Boolean variable to indicate whether the pre-whitenning of the influence functions TS should be done through a robust filter.}

\item{fitting.method}{Distribution used in the standard errors computation. Should be one of "Exponential" (default) or "Gamma".}

\item{a}{First adaptive method parameter.}

\item{b}{Second adaptive method parameter.}

\item{...}{Additional parameters.}
}
\value{
A vector standard error estimates.
}
\description{
\code{EstimatorSE} computes the standard error for specified risk and performance measures.
}
\examples{
# Loading data from PerformanceAnalytics
data(edhec, package = "PerformanceAnalytics")
class(edhec)
# Changing the data colnames
names(edhec) = c("CA", "CTA", "DIS", "EM", "EMN",
                 "ED", "FIA", "GM", "LS", "MA",
                 "RV", "SS", "FOF")
# Computing the standard errors for
# the three influence functions based approaches
EstimatorSE(edhec[,"CA"], se.method=c("IFcor"),
            cleanOutliers=FALSE,
            fitting.method=c("Exponential", "Gamma")[1])

}
\author{
Xin Chen, \email{chenx26@uw.edu}

Anthony-Alexander Christidis, \email{anthony.christidis@stat.ubc.ca}
}
