% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xform.R
\name{xform}
\alias{xform}
\title{Obtain an affine matrix corresponding to the ``xform'' of an image}
\usage{
xform(image, useQuaternionFirst = TRUE)
}
\arguments{
\item{image}{An image, in any acceptable form (see \code{\link{isImage}}).}

\item{useQuaternionFirst}{A single logical value. If \code{TRUE}, the
``qform'' matrix will be used first, if it is defined; otherwise the
``sform'' matrix will take priority.}
}
\value{
A affine matrix corresponding to the ``qform'' or ``sform''
  information in the image header. This is a plain matrix, which does not
  have the \code{"affine"} class or \code{source} and \code{target}
  attributes.
}
\description{
This function converts the ``qform'' or ``sform'' information in a NIfTI
header into its corresponding affine matrix. These two ``xform'' mechanisms
are defined by the NIfTI standard and may both be in use in a particular
image header.
}
\author{
Jon Clayden <code@clayden.org>
}
\references{
The NIfTI-1 standard (\url{http://nifti.nimh.nih.gov/nifti-1})
  is the definitive reference on ``xform'' conventions.
}

