% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/getIndex.R
\name{getIndex}
\alias{getIndex}
\title{Indexes}
\usage{
getIndex(graph, label = character())
}
\arguments{
\item{graph}{A graph object.}

\item{label}{A character vector.}
}
\value{
A data.frame.
}
\description{
Get all indexes for a given label or for the entire graph database.
}
\details{
Omitting the \code{label} argument returns all indexes in the graph database.
}
\examples{
\dontrun{
graph = startGraph("http://localhost:7474/db/data/")
clear(graph)

addIndex(graph, "Person", "status")
addIndex(graph, "School", "type")

getIndex(graph, "Person")
getIndex(graph)
}
}
\seealso{
\code{\link{addIndex}}, \code{\link{dropIndex}}
}

