% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{dataset07}
\alias{dataset07}
\title{Lucy Warren FROC dataset}
\format{
A list with 3 elements: \code{$ratings}, \code{$lesions} and \code{$descriptions}; \code{$ratings}
   contain 3 elements, \code{$NL}, \code{$LL} and \code{$LL_IL} as sub-lists; \code{$lesions}
   contain 3 elements, \code{$perCase}, \code{$IDs} and \code{$weights} as sub-lists; \code{$descriptions}
   contain 7 elements, \code{$fileName}, \code{$type}, \code{$name},
   \code{$truthTableStr}, \code{$design}, \code{$modalityID} and \code{$readerID} as sub-lists;
\itemize{
\item{\code{rating$NL}}{, num [1:5, 1:7, 1:162, 1:4], ratings of non-lesion localizations, NLs}
\item{\code{rating$LL}}{, num [1:5, 1:7, 1:81, 1:3], ratings of lesion localizations, LLs}
\item{\code{rating$LL_IL}}{NA, this placeholder is used only for LROC data}
\item{\code{lesions$perCase}}{, int [1:81], number of lesions per diseased case}
\item{\code{lesions$IDs}}{, num [1:81, 1:3], numeric labels of lesions on diseased cases}
\item{\code{lesions$weights}}{, num [1:81, 1:3], weights (or clinical importances) of lesions}
\item{\code{descriptions$fileName}}{, chr, "dataset07", base name of dataset in `data` folder}
\item{\code{descriptions$type}}{, chr "FROC", the data type}
\item{\code{descriptions$name}}{, chr "LUCY-WARREN", the name of the dataset}
\item{\code{descriptions$truthTableStr}}{, num [1:5, 1:7, 1:162, 1:4], truth table structure}
\item{\code{descriptions$design}}{, chr "FCTRL", study design, factorial dataset}
\item{\code{descriptions$modalityID}}{, [1:5] "1" "2" "3" "4" ..., treatment labels}
\item{\code{descriptions$readerID}}{, chr [1:7] "1" "2" "3" "4" ..., reader labels}
}
}
\usage{
dataset07
}
\description{
This is referred to in the book as the "OPT" dataset (for OptiMam). It consists of 162 cases, 
81 of which are diseased, interpreted in five treatments (see reference, basically different ways
of acquiring the images) by seven radiologists using the FROC paradigm.
}
\examples{
str(dataset07)
PlotEmpiricalOperatingCharacteristics(dataset = dataset07, opChType = "wAFROC")$Plot


}
\references{
Warren LM, Mackenzie A, Cooke J, et al. Effect of image quality on 
calcification detection in digital mammography. 
Medical Physics. 2012;39(6):3202-3213.
}
\keyword{datasets}
