% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StSignificanceTesting.R
\name{StSignificanceTesting}
\alias{StSignificanceTesting}
\title{Performs DBM or OR significance testing for factorial or split-plot A,C datasets}
\usage{
StSignificanceTesting(
  dataset,
  FOM,
  FPFValue = 0.2,
  alpha = 0.05,
  method = "DBM",
  covEstMethod = "jackknife",
  nBoots = 200,
  analysisOption = "ALL",
  tempOrgCode = FALSE
)
}
\arguments{
\item{dataset}{The dataset to be analyzed, see \code{\link{RJafroc-package}}. 
Must have two or more treatments and two or more readers. The dataset design
can be "FCTRL", "SPLIT-PLOT-A" or "SPLIT-PLOT-C".}

\item{FOM}{The figure of merit, see \code{\link{UtilFigureOfMerit}}}

\item{FPFValue}{Only needed for \code{LROC} data \strong{and} FOM = "PCL" or "ALROC";
where to evaluate a partial curve based figure of merit. The default is 0.2.}

\item{alpha}{The significance level of the test of the null hypothesis that all 
treatment effects are zero; the default is 0.05}

\item{method}{The significance testing method to be used:
\code{"DBM"} (the default) or \code{"OR"}, representing the Dorfman-Berbaum-Metz
and the Obuchowski-Rockette significance testing methods, respectively.}

\item{covEstMethod}{The covariance matrix estimation method
   in \code{ORH} analysis (for \code{method = "DBM"} the jackknife is always used).
   \itemize{ 
   \item \code{"Jackknife"}, the default, 
   \item \code{"Bootstrap"}, in which case \code{nBoots} (above) is relevant, 
   \item \code{"DeLong"}; requires \code{FOM = "Wilcoxon" or "ROI" or "HrAuc"}, 
   otherwise an error results.
}}

\item{nBoots}{The number of bootstraps (defaults to 200), relevant only if 
\code{covEstMethod = "bootstrap"} and \code{method = "OR"}}

\item{analysisOption}{Determines which factors are regarded as random vs. fixed:
\itemize{ 
   \item \code{"RRRC"} = random-reader random case, 
   \item \code{"FRRC"} = fixed-reader random case, 
   \item \code{"RRFC"} = random-reader fixed case, 
   \item \code{"ALL"} =  outputs results of \code{"RRRC"}, \code{"FRRC"} 
   and \code{"RRFC"} analyses - this is the default.
}}

\item{tempOrgCode, }{default FALSE; if TRUE, then code from version 0.0.1 of RJafroc
is used (see RJafroc_0.0.1.tar). This is intended to check against errors 
that crept in subsequent to the original version as I attempted to improve 
the organization of the code and the output. As implicit in the name of this 
temporary flag, it will eventually be removed.}
}
\value{
\strong{For \code{method = "DBM"} the returned list contains 4 dataframes:}

\item{FOMs}{Contains \code{foms}, \code{trtMeans} and \code{trtMeanDiffs}: 
   see return of \code{\link{UtilFigureOfMerit}}}

\item{ANOVA}{Contains \code{TRCAnova}, \code{VarCom}, \code{IndividualTrt} 
   and \code{IndividualRdr} ANOVA tables of pseudovalues}

\item{RRRC}{Contains results of \code{"RRRC"} analyses: \code{FTests}, 
   \code{ciDiffTrt}, \code{ciAvgRdrEachTrt}}

\item{FRRC}{Contains results of \code{"FRRC"} analyses: \code{FTests}, 
   \code{ciDiffTrt}, \code{ciAvgRdrEachTrt}, \code{ciDiffTrtEachRdr}}

\item{RRFC}{Contains results of \code{"RRFC"} analyses: \code{FTests}, 
   \code{ciDiffTrt}, \code{ciAvgRdrEachTrt}}

\strong{For \code{method = "OR"} the return list contains 4 dataframes:}

\item{FOMs}{Contains \code{foms}, \code{trtMeans} and \code{trtMeanDiffs}: 
   \code{\link{UtilFigureOfMerit}}}

\item{ANOVA}{Contains \code{TRAnova}, \code{VarCom}, \code{IndividualTrt} 
   and \code{IndividualRdr} ANOVA tables of FOM values}

\item{RRRC}{Contains results of \code{"RRRC"} analyses - same 
   organization as DBM, see above}

\item{FRRC}{Contains results of \code{"FRRC"} analyses - ditto}

\item{RRFC}{Contains results of \code{"RRFC"} analyses- ditto}
}
\description{
Performs Dorfman-Berbaum-Metz (DBM) or Obuchowski-Rockette (OR) 
   significance testing, for specified dataset; 
   significance testing refers to analysis designed to assign a P-value, 
   and other statistics, for 
   rejecting the null hypothesis (NH) that the reader-averaged 
   figure of merit (FOM) differences between treatments is zero. The results of 
   the analysis are best visualized in the text or  
   Excel-formatted files produced by \code{\link{UtilOutputReport}}.
}
\examples{
StSignificanceTesting(dataset02,FOM = "Wilcoxon", method = "DBM") 
StSignificanceTesting(dataset02,FOM = "Wilcoxon", method = "OR")
## following is split-plot-c analysis using a simulated split-plot-c dataset
StSignificanceTesting(datasetFROCSpC, FOM = "wAFROC", method = "OR")

\donttest{
StSignificanceTesting(dataset05, FOM = "wAFROC")
StSignificanceTesting(dataset05, FOM = "HrAuc", method = "DBM") 
StSignificanceTesting(dataset05, FOM = "SongA1", method = "DBM") 
StSignificanceTesting(dataset05, FOM = "SongA2", method = "DBM") 
StSignificanceTesting(dataset05, FOM = "wAFROC1", method = "DBM")
StSignificanceTesting(dataset05, FOM = "AFROC1", method = "DBM")
StSignificanceTesting(dataset05, FOM = "AFROC", method = "DBM")
} 


}
\references{
Dorfman DD, Berbaum KS, Metz CE (1992) ROC characteristic rating analysis: 
Generalization to the Population of Readers and Patients with the Jackknife method, Invest. Radiol. 27, 723-731.

Obuchowski NA, Rockette HE (1995) Hypothesis Testing of the Diagnostic Accuracy for Multiple Diagnostic Tests:  
An ANOVA Approach with Dependent Observations, Communications in Statistics: Simulation and Computation 24, 285-308.

Hillis SL (2014) A marginal-mean ANOVA approach for analyzing multireader multicase radiological imaging data, 
Statistics in medicine 33, 330-360.

Chakraborty DP (2017) \emph{Observer Performance Methods for Diagnostic Imaging - Foundations, 
Modeling, and Applications with R-Based Examples}, CRC Press, Boca Raton, FL.
}
