% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SsPowerGivenJK.R
\name{SsPowerGivenJKDbmVarComp}
\alias{SsPowerGivenJKDbmVarComp}
\title{Power given J, K and Dorfman-Berbaum-Metz variance components}
\usage{
SsPowerGivenJKDbmVarComp(
  J,
  K,
  effectSize,
  varYTR,
  varYTC,
  varYEps,
  alpha = 0.05,
  option
)
}
\arguments{
\item{J}{The number of readers}

\item{K}{The number of cases}

\item{effectSize}{The effect size}

\item{varYTR}{The treatment-reader DBM variance component}

\item{varYTC}{The treatment-case DBM variance component}

\item{varYEps}{The error-term DBM variance component}

\item{alpha}{The size of the test (default = 0.05)}

\item{option}{The desired generalization ("RRRC", "FRRC", "RRFC", "ALL")}
}
\value{
A list object containing the estimated power and associated statistics
   for each desired generalization.
}
\description{
Power given J, K and Dorfman-Berbaum-Metz variance components
}
\details{
The variance components are obtained using \link{StSignificanceTesting}
   with \code{method = "DBMH"}.
}
\examples{
VarComp <- StSignificanceTesting(dataset02, FOM = "Wilcoxon", method = "DBMH", 
   option = "RRRC")$varComp
varYTR <- VarComp$varTR
varYTC <- VarComp$varTC
varYEps <- VarComp$varErr
ret <- SsPowerGivenJKDbmVarComp (J = 5, K = 100, effectSize = 0.05, varYTR, 
   varYTC, varYEps, option = "RRRC")
cat("RRRC power = ", ret$powerRRRC)
  
}
