/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.ssf.DefaultSsf;
import ec.tstoolkit.ssf.ISsf;

public class DefaultTimeInvariantSsf
extends DefaultSsf {
    public static DefaultTimeInvariantSsf of(ISsf ssf) {
        if (!ssf.isTimeInvariant()) {
            return null;
        }
        DefaultTimeInvariantSsf nssf = new DefaultTimeInvariantSsf();
        int dim = ssf.getStateDim();
        int nd = ssf.getNonStationaryDim();
        int nr = ssf.getTransitionResCount();
        int rdim = ssf.getTransitionResDim();
        nssf.initialize(dim, nr, rdim);
        ssf.Z(0, new DataBlock(nssf.m_Z));
        ssf.T(0, nssf.m_T.subMatrix());
        if (nr < dim) {
            ssf.R(0, SubArrayOfInt.create(nssf.m_R));
        }
        if (ssf.hasW()) {
            ssf.W(0, nssf.m_W.subMatrix());
        }
        ssf.Q(0, nssf.m_Q.subMatrix());
        if (nd > 0) {
            nssf.m_B0 = new Matrix(dim, nd);
            ssf.diffuseConstraints(nssf.m_B0.subMatrix());
        }
        nssf.m_Pf0 = new Matrix(dim, dim);
        ssf.Pf0(nssf.m_Pf0.subMatrix());
        return nssf;
    }

    @Override
    public boolean hasW() {
        return this.m_W != null;
    }

    @Override
    public boolean isMeasurementEquationTimeInvariant() {
        return true;
    }

    @Override
    public boolean isTimeInvariant() {
        return true;
    }

    @Override
    public boolean isTransitionEquationTimeInvariant() {
        return true;
    }

    @Override
    public boolean isTransitionResidualTimeInvariant() {
        return true;
    }

    @Override
    protected boolean loadQ(int pos, Matrix q) {
        return true;
    }

    @Override
    protected boolean loadR(int pos, int[] r) {
        return true;
    }

    @Override
    protected boolean loadT(int pos, Matrix t) {
        return true;
    }

    @Override
    protected boolean loadW(int pos, Matrix w) {
        return true;
    }

    @Override
    protected boolean loadZ(int pos, double[] z) {
        return true;
    }

    public void setQ(Matrix q) {
        this.m_Q = q;
    }

    public void setR(int[] r) {
        this.m_R = r == null ? null : (int[])r.clone();
    }

    public void setT(Matrix t) {
        this.m_T = t;
    }

    public void setW(Matrix w) {
        this.m_W = w;
    }

    public void setZ(double[] z) {
        this.m_Z = (double[])z.clone();
    }
}

