/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.eco;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.data.WindowType;
import ec.tstoolkit.maths.matrices.LowerTriangularMatrix;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;

public class RobustCovarianceMatrixComputer {
    private WindowType winType = WindowType.Bartlett;
    private int truncationLag = 12;
    private Matrix xe;
    private Matrix s;
    private Matrix xx;
    private Matrix v;

    public void compute(SubMatrix x, IReadDataBlock e) {
        this.s = null;
        this.xx = null;
        this.v = null;
        this.xe = this.xe(x, e);
        int n = x.getRowsCount();
        int nx = x.getColumnsCount();
        double[] w = this.winType.window(this.truncationLag + 1);
        this.xx = Matrix.square(nx);
        SymmetricMatrix.XtX(x, this.xx.all());
        Matrix xex = SymmetricMatrix.XtX(this.xe);
        this.s = xex.clone();
        this.s.mul(w[0]);
        SubMatrix ol = Matrix.square(nx).all();
        for (int l = 1; l <= this.truncationLag; ++l) {
            SubMatrix m = this.xe.subMatrix(0, n - l, 0, nx);
            SubMatrix ml = this.xe.subMatrix(l, n, 0, nx);
            ol.product(m.transpose(), ml);
            this.s.all().addAY(w[l], ol);
            this.s.all().addAY(w[l], ol.transpose());
        }
        this.s.mul(1.0 / (double)n);
    }

    private Matrix xe(SubMatrix x, IReadDataBlock e) {
        Matrix xe = new Matrix(x);
        DataBlockIterator columns = xe.columns();
        DataBlock column = columns.getData();
        do {
            column.apply(e, (a, b) -> a * b);
        } while (columns.next());
        return xe;
    }

    public Matrix getXe() {
        return this.xe;
    }

    public Matrix getOmega() {
        return this.s;
    }

    public Matrix getRobustCovariance() {
        Matrix Lo = this.s.clone();
        SymmetricMatrix.lcholesky(Lo);
        Matrix Lx = this.xx.clone();
        SymmetricMatrix.lcholesky(Lx);
        LowerTriangularMatrix.rsolve(Lx, Lo.all());
        LowerTriangularMatrix.lsolve(Lx, Lo.all().transpose());
        Matrix XXt = SymmetricMatrix.XXt(Lo);
        XXt.mul(this.xe.getRowsCount());
        return XXt;
    }

    public WindowType getWindowType() {
        return this.winType;
    }

    public void setWindowType(WindowType winType) {
        this.winType = winType;
    }

    public int getTruncationLag() {
        return this.truncationLag;
    }

    public void setTruncationLag(int truncationLag) {
        this.truncationLag = truncationLag;
    }
}

