/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.timeseries.TsException;
import ec.tstoolkit.timeseries.regression.AbstractTsModifier;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.util.List;

public class LaggedTsVariable
extends AbstractTsModifier {
    private final int m_firstlag;
    private final int m_lastlag;

    public LaggedTsVariable(ITsVariable var, int firstlag, int lastlag) {
        super(var);
        if (lastlag < firstlag) {
            throw new TsException("Invalid lags");
        }
        this.m_firstlag = firstlag;
        this.m_lastlag = lastlag;
    }

    @Override
    public void data(TsDomain domain, List<DataBlock> data) {
        int nvar = this.var.getDim();
        int i = this.m_firstlag;
        int k = 0;
        while (i <= this.m_lastlag) {
            this.var.data(domain.move(-i), data.subList(k, k + nvar));
            ++i;
            k += nvar;
        }
    }

    @Override
    public TsDomain getDefinitionDomain() {
        TsDomain dom = this.var.getDefinitionDomain();
        if (dom == null) {
            return null;
        }
        return new TsDomain(dom.getStart().plus(this.m_lastlag), dom.getLength() - this.m_lastlag + this.m_firstlag);
    }

    @Override
    public TsFrequency getDefinitionFrequency() {
        return this.var.getDefinitionFrequency();
    }

    @Override
    public String getDescription(TsFrequency context) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.var.getDescription(context));
        if (this.m_firstlag > 0) {
            builder.append("[-").append(this.m_firstlag).append(" : ");
        } else if (this.m_firstlag < 0) {
            builder.append("[+").append(-this.m_firstlag).append(" : ");
        }
        if (this.m_lastlag > 0) {
            builder.append('-').append(this.m_lastlag).append(']');
        } else if (this.m_lastlag < 0) {
            builder.append('+').append(-this.m_lastlag).append(']');
        }
        return builder.toString();
    }

    @Override
    public int getDim() {
        return this.getLagsCount() * this.var.getDim();
    }

    public int getFirstLag() {
        return this.m_firstlag;
    }

    @Override
    public String getItemDescription(int idx, TsFrequency context) {
        int nvar = this.var.getDim();
        int lag = this.m_firstlag + idx / nvar;
        StringBuilder builder = new StringBuilder();
        builder.append(this.var.getItemDescription(idx % nvar, context));
        if (lag > 0) {
            builder.append(" [-").append(lag).append(']');
        } else if (lag < 0) {
            builder.append(" [+").append(-lag).append(']');
        }
        return builder.toString();
    }

    public int getLagsCount() {
        return this.m_lastlag - this.m_firstlag + 1;
    }

    public int getLastLag() {
        return this.m_lastlag;
    }

    @Override
    public ITsVariable getVariable() {
        return this.var;
    }

    @Override
    public boolean isSignificant(TsDomain domain) {
        int n = domain.getLength() + this.m_firstlag - this.m_lastlag;
        if (n <= 0) {
            return false;
        }
        return this.var.isSignificant(new TsDomain(domain.getStart().minus(this.m_firstlag), n));
    }

    @Override
    public String getName() {
        int n = this.getDim();
        if (n == 0) {
            return this.var.getName();
        }
        return ITsVariable.shortName(this.var.getName()) + '#' + n;
    }
}

