% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_workspace.R
\name{get_object}
\alias{get_object}
\alias{get_all_objects}
\title{Get objects inside a workspace or multiprocessing}
\usage{
get_object(x, pos = 1)

get_all_objects(x)
}
\arguments{
\item{x}{the object in which to store the extracted \code{multiprocessing} or \code{sa_item}.}

\item{pos}{the index of the object to extract.}
}
\value{
An object of class \code{multiprocessing} or \code{sa_item} (for \code{get_object()}) or a list
of objects of class \code{multiprocessing} or \code{sa_item} (for \code{get_all_objects()}).
}
\description{
Generic functions to retrieve all (\code{get_all_objects()}) \code{multiprocessing} (respectively \code{sa_item})
from a \code{workspace} (respectively \code{multiprocessing}) or to retrieve a single one (\code{get_object()}) .
}
\examples{
\donttest{

sa_x13 <- x13(ipi_c_eu[, "FR"], spec = "RSA5c")

wk <- new_workspace()
mp <- new_multiprocessing(wk, "sa1")
add_sa_item(wk, "sa1", sa_x13, "X13")

# A way to retrieve the multiprocessing:
mp <- get_object(wk, 1)
# And the sa_item object:
sa_item <- get_object(mp, 1)
}
}
\seealso{
Other functions to retrieve information from a workspace, multiprocessing or sa_item: \code{\link{count}}, \code{\link{get_model}}, \code{\link{get_name}}, \code{\link{get_ts}}.
}
