/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.data;

import ec.tstoolkit.data.SubArray;
import ec.tstoolkit.design.PrimitiveReplacementOf;
import ec.tstoolkit.utilities.Arrays2;

@PrimitiveReplacementOf(generic=SubArray.class, primitive=int.class)
public final class SubArrayOfInt {
    public static final SubArrayOfInt EMPTY = SubArrayOfInt.create(Arrays2.EMPTY_INT_ARRAY);
    private final int[] m_data;
    private final int m_beg;
    private final int m_end;
    private final int m_inc;

    public static SubArrayOfInt create(int[] data) {
        return new SubArrayOfInt(data, 0, data.length, 1);
    }

    public static SubArrayOfInt create(int[] data, int beg, int end, int inc) {
        return new SubArrayOfInt(data, beg, end, inc);
    }

    private SubArrayOfInt(int[] data, int beg, int end, int inc) {
        this.m_data = data;
        this.m_beg = beg;
        this.m_end = end;
        this.m_inc = inc;
    }

    public void add(int idx, int value) {
        int n = this.m_beg + idx * this.m_inc;
        this.m_data[n] = this.m_data[n] + value;
    }

    public void copy(SubArrayOfInt a) {
        int tcur = this.m_beg;
        int scur = a.m_beg;
        if (this.m_inc == 1 && a.m_inc == 1) {
            while (tcur != this.m_end) {
                this.m_data[tcur++] = a.m_data[scur++];
            }
        } else {
            while (tcur != this.m_end) {
                this.m_data[tcur] = a.m_data[scur];
                tcur += this.m_inc;
                scur += a.m_inc;
            }
        }
    }

    public void copyFrom(int[] a, int start) {
        int tcur;
        int scur = start;
        if (this.m_inc == 1) {
            while (tcur != this.m_end) {
                this.m_data[tcur++] = a[scur++];
            }
        } else {
            for (tcur = this.m_beg; tcur != this.m_end; tcur += this.m_inc) {
                this.m_data[tcur] = a[scur++];
            }
        }
    }

    public int get(int idx) {
        return this.m_data[this.m_beg + idx * this.m_inc];
    }

    public int getLength() {
        return this.m_inc == 0 ? 0 : (this.m_end - this.m_beg) / this.m_inc;
    }

    public boolean isEmpty() {
        return this.m_beg == this.m_end;
    }

    public SubArrayOfInt range(int i0, int i1) {
        return new SubArrayOfInt(this.m_data, this.m_beg + i0 * this.m_inc, this.m_beg + i1 * this.m_inc, this.m_inc);
    }

    public void set(int tval) {
        int cur;
        if (this.m_inc == 1) {
            while (cur != this.m_end) {
                this.m_data[cur++] = tval;
            }
        } else {
            for (cur = this.m_beg; cur != this.m_end; cur += this.m_inc) {
                this.m_data[cur] = tval;
            }
        }
    }

    public void set(int idx, int value) {
        this.m_data[this.m_beg + idx * this.m_inc] = value;
    }

    public void add(int del) {
        int cur;
        if (del == 0) {
            return;
        }
        if (this.m_inc == 1) {
            while (cur != this.m_end) {
                int n = cur++;
                this.m_data[n] = this.m_data[n] + del;
            }
        } else {
            for (cur = this.m_beg; cur != this.m_end; cur += this.m_inc) {
                int n = cur;
                this.m_data[n] = this.m_data[n] + del;
            }
        }
    }
}

