% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/REM_CFA.R
\name{REM_CFA}
\alias{REM_CFA}
\title{Robust Estimation Maximization Estimates for Confirmatory Factor Analysis}
\usage{
REM_CFA(X, delta = 0.05, model = NA, ctrREM = controlREM())
}
\arguments{
\item{X}{data to analyze; should be a data frame or matrix}

\item{delta}{hyperparameter between 0 and 1 that captures the researcher’s tolerance of incorrectly down-weighting data from the model (default = 0.05).}

\item{model}{string variable that contains each structural equation in a new line where equalities are denoted by the symbol "~".}

\item{ctrREM}{control parameters (default: (steps = 25, tol = 1e-6, maxiter = 1e3, min_weights = 1e-30, max_ueps =  0.3, chk_gamma = 0.9, n = 2e4))}
}
\value{
REM_CFA returns an object of class "REM". The function \code{\link[=summary]{summary()}} is used to obtain estimated parameters from the model. An object of class "REM" in Confirmatory Factor Analysis is a list of outputs with four different components: the matched call (call), estimates using traditional expectation maximization (EM_output), estimates using robust expectation maximization (REM_output), and a summary table (summary_table). The list contains the following components:
\item{call}{match call}
\item{model}{model frame}
\item{delta}{hyperparameter between 0 and 1 that captures the researcher’s tolerance of incorrectly down-weighting data from the model}
\item{k}{number of factors}
\item{constraints}{p x k matrix of zeros and ones denoting the factors (rows) and observed variables (columns)}
\item{epsilon}{hyperparameter on the likelihood scale}
\item{AIC_rem}{Akaike Information Criterion}
\item{BIC_rem}{Bayesian Information Criterion}
\item{mu}{item intercepts}
\item{lambda}{factor loadings}
\item{psi}{unique variances of items}
\item{gamma}{average weights}
\item{weights}{estimated REM weights}
\item{ind_lik}{likelihood value for each individual}
\item{lik_rem}{joint log-likelihood evaluated at REM estimates}
\item{lik}{joint log-likelihood evaluated at EM estimates}
\item{summary_table}{summary of EM and REM estimates, SEs, Z statistics, p-values, and 95\% confidence intervals}
}
\description{
This function uses the robust expectation maximization (REM) algorithm to estimate the parameters of a confirmatory factor analysis model as suggested by Nieser & Cochran (2021).
}
\examples{
\donttest{
# Creating latent model
library(lavaan)
library(GPArotation)
df <- HolzingerSwineford1939
data = df[,-c(1:6)]

model <- "Visual  =~  x1 + x2 + x3
         Textual =~  x4 + x5 + x6
         Speed   =~  x7 + x8 + x9"

# Modeling Confirmatory Factor Analysis
model_CFA = REM_CFA(X = data, delta = 0.05, model = model)
summary(model_CFA)
}
}
\references{
Nieser, K. J., & Cochran, A. L. (2021). Addressing heterogeneous populations in latent variable settings through robust estimation. Psychological Methods.
}
\seealso{
\code{\link[=REM_EFA]{REM_EFA()}}, \code{\link[=summary.REMLA]{summary.REMLA()}}
}
\author{
Bryan Ortiz-Torres (bortiztorres@wisc.edu); Kenneth Nieser (nieser@stanford.edu)
}
