% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_tables.R
\name{bind_tables}
\alias{bind_tables}
\title{Extract tibbles from a REDCapTidieR supertibble and bind it to an environment}
\usage{
bind_tables(.data, environment = global_env(), tbls = NULL, structure = NULL)
}
\arguments{
\item{.data}{A tibble generated by \code{read_redcap_tidy()}. Required.}

\item{environment}{The environment to add the tibbles to. Default is
\code{global_env()}).}

\item{tbls}{A vector of \code{form_name}s. Default behavior is all tibbles.}

\item{structure}{Specify REDCap structure to load into environment, either
\code{repeating} or \code{nonrepeating}. Defaults to all structures.}
}
\value{
This function returns nothing as it's used solely for its side effect of
modifying an environment.
}
\description{
Take a supertibble generated with \code{read_redcap_tidy()}
and bind it to an environment. The default is the global environment.
}
\examples{
# Designate a sample environment
sample_env <- environment()

# Supply a `read_redcap_tidy()` output to bind
sample_data <- tibble::tribble(
  ~redcap_form_name,    ~redcap_data,   ~structure,
  "super_hero_powers",   list(),         "repeating",
  "heroes_information",  list(),         "nonrepeating"
)

bind_tables(sample_data, sample_env)

}
