% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.R
\docType{methods}
\name{AthenaWriteTables}
\alias{AthenaWriteTables}
\alias{dbWriteTable,AthenaConnection,character,data.frame-method}
\alias{dbWriteTable,AthenaConnection,Id,data.frame-method}
\alias{dbWriteTable,AthenaConnection,SQL,data.frame-method}
\title{Convenience functions for reading/writing DBMS tables}
\usage{
\S4method{dbWriteTable}{AthenaConnection,character,data.frame}(conn, name,
  value, overwrite = FALSE, append = FALSE, row.names = NA,
  field.types = NULL, partition = NULL, s3.location = NULL,
  file.type = c("tsv", "csv", "parquet"), compress = FALSE,
  max.batch = Inf, ...)

\S4method{dbWriteTable}{AthenaConnection,Id,data.frame}(conn, name, value,
  overwrite = FALSE, append = FALSE, row.names = NA,
  field.types = NULL, partition = NULL, s3.location = NULL,
  file.type = c("tsv", "csv", "parquet"), compress = FALSE,
  max.batch = Inf, ...)

\S4method{dbWriteTable}{AthenaConnection,SQL,data.frame}(conn, name, value,
  overwrite = FALSE, append = FALSE, row.names = NA,
  field.types = NULL, partition = NULL, s3.location = NULL,
  file.type = c("tsv", "csv", "parquet"), compress = FALSE,
  max.batch = Inf, ...)
}
\arguments{
\item{conn}{An \code{\linkS4class{AthenaConnection}} object, produced by [DBI::dbConnect()]}

\item{name}{A character string specifying a table name. Names will be
automatically quoted so you can use any sequence of characters, not
just any valid bare table name.}

\item{value}{A data.frame to write to the database.}

\item{overwrite}{Allows overwriting the destination table. Cannot be \code{TRUE} if \code{append} is also \code{TRUE}.}

\item{append}{Allow appending to the destination table. Cannot be \code{TRUE} if \code{overwrite} is also \code{TRUE}. Existing Athena DDL file type will be retained
and used when uploading data to AWS Athena. If parameter \code{file.type} doesn't match AWS Athena DDL file type a warning message will be created 
notifying user and \code{RAthena} will use the file type for the Athena DDL.}

\item{row.names}{Either \code{TRUE}, \code{FALSE}, \code{NA} or a string.

If \code{TRUE}, always translate row names to a column called "row_names".
If \code{FALSE}, never translate row names. If \code{NA}, translate
rownames only if they're a character vector.

A string is equivalent to \code{TRUE}, but allows you to override the
default name.

For backward compatibility, \code{NULL} is equivalent to \code{FALSE}.}

\item{field.types}{Additional field types used to override derived types.}

\item{partition}{Partition Athena table (needs to be a named list or vector) for example: \code{c(var1 = "2019-20-13")}}

\item{s3.location}{s3 bucket to store Athena table, must be set as a s3 uri for example ("s3://mybucket/data/"). 
By default s3.location is set s3 staging directory from \code{\linkS4class{AthenaConnection}} object.}

\item{file.type}{What file type to store data.frame on s3, RAthena currently supports ["tsv", "csv", "parquet"]. Default delimited file type is "tsv", in previous versions
of \code{RAthena (=< 1.6.0)} file type "csv" was used as default. The reason for the change is that columns containing \code{Array/JSON} format cannot be written to 
Athena due to the separating value ",". This would cause issues with AWS Athena.                  
\strong{Note:} "parquet" format is supported by the \code{arrow} package and it will need to be installed to utilise the "parquet" format.}

\item{compress}{\code{FALSE | TRUE} To determine if to compress file.type. If file type is ["csv", "tsv"] then "gzip" compression is used, for file type "parquet" 
"snappy" compression is used.}

\item{max.batch}{Split the data frame by max number of rows i.e. 100,000 so that multiple files can be uploaded into AWS S3. By default when compression
is set to \code{TRUE} and file.type is "csv" or "tsv" max.batch will split data.frame into 20 batches. This is to help the 
performance of AWS Athena when working with files compressed in "gzip" format. \code{max.batch} will not split the data.frame 
when loading file in parquet format. For more information please go to \href{https://github.com/DyfanJones/RAthena/issues/36}{link}}

\item{...}{Other arguments used by individual methods.}
}
\value{
\code{dbWriteTable()} returns \code{TRUE}, invisibly. If the table exists, and both append and overwrite
        arguments are unset, or append = TRUE and the data frame with the new data has different column names,
        an error is raised; the remote table remains unchanged.
}
\description{
Convenience functions for reading/writing DBMS tables
}
\examples{
\dontrun{
# Note: 
# - Require AWS Account to run below example.
# - Different connection methods can be used please see `RAthena::dbConnect` documnentation

library(DBI)

# Demo connection to Athena using profile name 
con <- dbConnect(RAthena::athena())

# List existing tables in Athena
dbListTables(con)

# Write data.frame to Athena table
dbWriteTable(con, "mtcars", mtcars,
             partition=c("TIMESTAMP" = format(Sys.Date(), "\%Y\%m\%d")),
             s3.location = "s3://mybucket/data/")
             
# Read entire table from Athena
dbReadTable(con, "mtcars")

# List all tables in Athena after uploading new table to Athena
dbListTables(con)

# Checking if uploaded table exists in Athena
dbExistsTable(con, "mtcars")

# using default s3.location
dbWriteTable(con, "iris", iris)

# Read entire table from Athena
dbReadTable(con, "iris")

# List all tables in Athena after uploading new table to Athena
dbListTables(con)

# Checking if uploaded table exists in Athena
dbExistsTable(con, "iris")

# Disconnect from Athena
dbDisconnect(con)
}
}
\seealso{
\code{\link[DBI]{dbWriteTable}}
}
