% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM.R
\name{m.step}
\alias{m.step}
\title{Maximization step}
\usage{
m.step(fik, Schrod, previous.weights, previous.centers, contamination, alpha,
  adj.factor, optim = "default")
}
\arguments{
\item{fik}{Matrix giving the probability of each mutation to belong to a specific clone}

\item{Schrod}{A list of dataframes (one for each sample), generated by the Patient_schrodinger_cellularities() function.}

\item{previous.weights}{Weights from the previous optimization step (used as priors for this step)}

\item{previous.centers}{Clone coordinates from previous optimization step (used as priors for this step)}

\item{contamination}{Numeric vector with the fraction of normal cells contaminating the sample}

\item{alpha}{Weight of each possibility / normalization so that the sum of all possibilities weighs equal to 1 mutation}

\item{adj.factor}{Factor to compute the probability: makes transition between the cellularity of the clone and the frequency observed}

\item{optim}{use L-BFS-G optimization from R ("default"), or from optimx ("optimx")}
}
\description{
Optimization of clone positions and proportion of mutations in each clone, based on the previously calculated expectation
}
\keyword{EM}
\keyword{Maximization}

