/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.type.codec;

import java.io.InputStream;
import org.openfast.NumericValue;
import org.openfast.ScalarValue;
import org.openfast.template.type.codec.IntegerCodec;
import org.openfast.template.type.codec.TypeCodec;

public final class NullableUnsignedInteger
extends IntegerCodec {
    private static final long serialVersionUID = 1L;

    NullableUnsignedInteger() {
    }

    public byte[] encodeValue(ScalarValue v) {
        if (v.isNull()) {
            return TypeCodec.NULL_VALUE_ENCODING;
        }
        return TypeCodec.UINT.encodeValue(((NumericValue)v).increment());
    }

    public ScalarValue decode(InputStream in) {
        NumericValue value = (NumericValue)TypeCodec.UINT.decode(in);
        if (value.equals(0)) {
            return null;
        }
        return value.decrement();
    }

    public boolean isNullable() {
        return true;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }
}

