/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.portfolio.optimizer;

import com.portfolioeffect.quant.client.portfolio.ArrayCache;
import com.portfolioeffect.quant.client.portfolio.Portfolio;
import com.portfolioeffect.quant.client.result.MethodResult;
import java.io.IOException;
import java.util.ArrayList;

public class ForecastedValues {
    private boolean[][] isSymbolCumulantPresent;
    private boolean[] isIndexCumulantPresent = new boolean[4];
    private int symbolNamber = 0;
    private ArrayList<String> symbolsName;
    private ArrayCache[][] forecastedSymbolValue;
    private ArrayCache[][] forecastedSymbolValueTime;
    private ArrayCache[] forecastedIndexValue;
    private ArrayCache[] forecastedIndexValueTime;
    private boolean[][] isCumulants;
    private boolean[] isCumulantsIndex = new boolean[2];
    private boolean isTimeStep;
    private ArrayCache timeStep;
    private ArrayCache timeStepTimeMilliSec;
    private int N = 1;

    public ForecastedValues(Portfolio portfolio) {
        this.symbolsName = new ArrayList<String>(portfolio.getSymbolNamesList());
        this.symbolNamber = this.symbolsName.size();
        this.isSymbolCumulantPresent = new boolean[this.symbolNamber][];
        this.forecastedSymbolValue = new ArrayCache[this.symbolNamber][];
        this.forecastedSymbolValueTime = new ArrayCache[this.symbolNamber][];
        this.isCumulants = new boolean[this.symbolNamber][];
        this.forecastedIndexValue = new ArrayCache[4];
        this.forecastedIndexValueTime = new ArrayCache[4];
        int i = 0;
        while (i < this.symbolNamber) {
            this.forecastedSymbolValue[i] = new ArrayCache[5];
            this.forecastedSymbolValueTime[i] = new ArrayCache[5];
            this.isCumulants[i] = new boolean[2];
            this.isCumulants[i][0] = false;
            this.isCumulants[i][1] = false;
            this.isSymbolCumulantPresent[i] = new boolean[5];
            this.isSymbolCumulantPresent[i][0] = false;
            this.isSymbolCumulantPresent[i][1] = false;
            this.isSymbolCumulantPresent[i][2] = false;
            this.isSymbolCumulantPresent[i][3] = false;
            this.isSymbolCumulantPresent[i][4] = false;
            ++i;
        }
        this.isIndexCumulantPresent[0] = true;
    }

    public MethodResult isAllForecastedValuesPresent() {
        String symbols = "";
        if (!this.isTimeStep) {
            symbols = String.valueOf(symbols) + "forecast time step;\n";
        }
        if (symbols.equals("")) {
            return new MethodResult();
        }
        return new MethodResult("The next values not defined:\n" + symbols);
    }

    public MethodResult setForecastTimeStep(double value) {
        return this.setForecastTimeStep(new double[]{value}, new long[]{-1L});
    }

    public MethodResult setForecastTimeStep(String value) {
        try {
            this.N = this.parseTimeInterval(value, "forecast time step");
            return this.setForecastTimeStep(new double[]{this.N}, new long[]{-1L});
        }
        catch (Exception e) {
            return new MethodResult(e.getMessage());
        }
    }

    public MethodResult setForecastTimeStep(double[] value, long[] time) {
        try {
            this.timeStep = new ArrayCache(value);
            this.timeStepTimeMilliSec = new ArrayCache(time);
        }
        catch (IOException e) {
            if (e.getMessage() != null) {
                return new MethodResult(e.getMessage());
            }
            return new MethodResult("Error while working with the local file system");
        }
        this.isTimeStep = true;
        return new MethodResult();
    }

    public MethodResult setSymbolForecastedExpReturn(String symbol, double[] value, long[] time) {
        if (!this.symbolsName.contains(symbol)) {
            return new MethodResult(String.format("Symbol %s is not found in portfolio.", symbol));
        }
        int index = this.symbolsName.indexOf(symbol);
        try {
            this.forecastedSymbolValue[index][0] = new ArrayCache(value);
            this.forecastedSymbolValueTime[index][0] = new ArrayCache(time);
        }
        catch (IOException e) {
            if (e.getMessage() != null) {
                return new MethodResult(e.getMessage());
            }
            return new MethodResult("Error while working with the local file system");
        }
        this.isSymbolCumulantPresent[index][0] = true;
        return new MethodResult();
    }

    public MethodResult setSymbolForecastedBeta(String symbol, double[] value, long[] time) {
        if (!this.symbolsName.contains(symbol)) {
            return new MethodResult(String.format("Symbol %s is not found in portfolio.", symbol));
        }
        int index = this.symbolsName.indexOf(symbol);
        try {
            this.forecastedSymbolValue[index][4] = new ArrayCache(value);
            this.forecastedSymbolValueTime[index][4] = new ArrayCache(time);
        }
        catch (IOException e) {
            if (e.getMessage() != null) {
                return new MethodResult(e.getMessage());
            }
            return new MethodResult("Error while working with the local file system");
        }
        this.isSymbolCumulantPresent[index][4] = true;
        return new MethodResult();
    }

    public MethodResult setSymbolForecastedVariance(String symbol, double[] value, long[] time) {
        if (!this.symbolsName.contains(symbol)) {
            return new MethodResult(String.format("Symbol %s is not found in portfolio.", symbol));
        }
        int index = this.symbolsName.indexOf(symbol);
        try {
            this.forecastedSymbolValue[index][1] = new ArrayCache(value);
            this.forecastedSymbolValueTime[index][1] = new ArrayCache(time);
        }
        catch (IOException e) {
            if (e.getMessage() != null) {
                return new MethodResult(e.getMessage());
            }
            return new MethodResult("Error while working with the local file system");
        }
        this.isSymbolCumulantPresent[index][1] = true;
        return new MethodResult();
    }

    public MethodResult setSymbolForecastedSkewness(String symbol, double[] value, long[] time) {
        if (!this.symbolsName.contains(symbol)) {
            return new MethodResult(String.format("Symbol %s is not found in portfolio.", symbol));
        }
        int index = this.symbolsName.indexOf(symbol);
        try {
            this.forecastedSymbolValue[index][2] = new ArrayCache(value);
            this.forecastedSymbolValueTime[index][2] = new ArrayCache(time);
        }
        catch (IOException e) {
            if (e.getMessage() != null) {
                return new MethodResult(e.getMessage());
            }
            return new MethodResult("Error while working with the local file system");
        }
        this.isSymbolCumulantPresent[index][2] = true;
        return new MethodResult();
    }

    public MethodResult setSymbolForecastedKurtosis(String symbol, double[] value, long[] time) {
        if (!this.symbolsName.contains(symbol)) {
            return new MethodResult(String.format("Symbol %s is not found in portfolio.", symbol));
        }
        int index = this.symbolsName.indexOf(symbol);
        try {
            this.forecastedSymbolValue[index][3] = new ArrayCache(value);
            this.forecastedSymbolValueTime[index][3] = new ArrayCache(time);
        }
        catch (IOException e) {
            if (e.getMessage() != null) {
                return new MethodResult(e.getMessage());
            }
            return new MethodResult("Error while working with the local file system");
        }
        this.isSymbolCumulantPresent[index][3] = true;
        return new MethodResult();
    }

    public MethodResult setSymbolForecastedCumulant1(String symbol, double[] value, long[] time) {
        return this.setSymbolForecastedExpReturn(symbol, value, time);
    }

    public MethodResult setSymbolForecastedCumulant2(String symbol, double[] value, long[] time) {
        return this.setSymbolForecastedVariance(symbol, value, time);
    }

    public MethodResult setSymbolForecastedCumulant3(String symbol, double[] value, long[] time) {
        MethodResult result = this.setSymbolForecastedSkewness(symbol, value, time);
        this.isCumulants[this.symbolsName.indexOf((Object)symbol)][0] = true;
        return result;
    }

    public MethodResult setSymbolForecastedCumulant4(String symbol, double[] value, long[] time) {
        MethodResult result = this.setSymbolForecastedKurtosis(symbol, value, time);
        this.isCumulants[this.symbolsName.indexOf((Object)symbol)][1] = true;
        return result;
    }

    public MethodResult setIndexForecastedVariance(double[] value, long[] time) {
        try {
            this.forecastedIndexValue[1] = new ArrayCache(value);
            this.forecastedIndexValueTime[1] = new ArrayCache(time);
        }
        catch (IOException e) {
            if (e.getMessage() != null) {
                return new MethodResult(e.getMessage());
            }
            return new MethodResult("Error while working with the local file system");
        }
        this.isIndexCumulantPresent[1] = true;
        return new MethodResult();
    }

    public MethodResult setIndexForecastedSkewness(double[] value, long[] time) {
        try {
            this.forecastedIndexValue[2] = new ArrayCache(value);
            this.forecastedIndexValueTime[2] = new ArrayCache(time);
        }
        catch (IOException e) {
            if (e.getMessage() != null) {
                return new MethodResult(e.getMessage());
            }
            return new MethodResult("Error while working with the local file system");
        }
        this.isIndexCumulantPresent[2] = true;
        return new MethodResult();
    }

    public MethodResult setIndexForecastedKurtosis(double[] value, long[] time) {
        try {
            this.forecastedIndexValue[3] = new ArrayCache(value);
            this.forecastedIndexValueTime[3] = new ArrayCache(time);
        }
        catch (IOException e) {
            if (e.getMessage() != null) {
                return new MethodResult(e.getMessage());
            }
            return new MethodResult("Error while working with the local file system");
        }
        this.isIndexCumulantPresent[3] = true;
        return new MethodResult();
    }

    public MethodResult setIndexForecastedCumulant2(double[] value, long[] time) {
        return this.setIndexForecastedVariance(value, time);
    }

    public MethodResult setIndexForecastedCumulant3(double[] value, long[] time) {
        MethodResult result = this.setIndexForecastedSkewness(value, time);
        this.isCumulantsIndex[0] = true;
        return result;
    }

    public MethodResult setIndexForecastedCumulant4(double[] value, long[] time) {
        MethodResult result = this.setIndexForecastedKurtosis(value, time);
        this.isCumulantsIndex[1] = true;
        return result;
    }

    private MethodResult checkResult(MethodResult result) throws Exception {
        if (result.hasError()) {
            throw new Exception(result.getErrorMessage());
        }
        return result;
    }

    private int parseTimeInterval(String s, String where) throws Exception {
        String ERROR = String.format("Incorrect parameter format:  %s", where);
        String[] res = s.split("(?<=\\D)(?=\\d)|(?<=\\d)(?=\\D)");
        String error = "";
        int number = 1;
        int scale = 0;
        if (res.length != 2) {
            error = ERROR;
        } else {
            try {
                number = Integer.parseInt(res[0]);
            }
            catch (Exception e) {
                error = ERROR;
            }
            if (res[1].equals("s")) {
                scale = 1;
            }
            if (res[1].equals("m")) {
                scale = 60;
            }
            if (res[1].equals("h")) {
                scale = 3600;
            }
            if (res[1].equals("d")) {
                scale = 23400;
            }
            if (res[1].equals("w")) {
                scale = 117000;
            }
            if (res[1].equals("mo")) {
                scale = 491400;
            }
            if (res[1].equals("y")) {
                scale = 5990400;
            }
            if (scale == 0) {
                error = ERROR;
            }
        }
        if (error.length() != 0) {
            throw new Exception(error);
        }
        return number * scale;
    }

    public MethodResult addToPortfolio(Portfolio portfolio) {
        try {
            this.checkResult(this.isAllForecastedValuesPresent());
            this.checkResult(portfolio.addUserData("expTimeStep", this.timeStep, this.timeStepTimeMilliSec));
            if (this.isIndexCumulantPresent[1]) {
                this.checkResult(portfolio.addUserData("IndexVariance", this.forecastedIndexValue[1], this.forecastedIndexValueTime[1]));
            }
            if (this.isIndexCumulantPresent[2]) {
                if (this.isIndexCumulantPresent[0]) {
                    this.checkResult(portfolio.addUserData("IndexCumulant3", this.forecastedIndexValue[2], this.forecastedIndexValueTime[2]));
                } else {
                    this.checkResult(portfolio.addUserData("IndexSkewness", this.forecastedIndexValue[2], this.forecastedIndexValueTime[2]));
                }
            }
            if (this.isIndexCumulantPresent[3]) {
                if (this.isIndexCumulantPresent[1]) {
                    this.checkResult(portfolio.addUserData("IndexCumulant4", this.forecastedIndexValue[3], this.forecastedIndexValueTime[3]));
                } else {
                    this.checkResult(portfolio.addUserData("IndexKurtosis", this.forecastedIndexValue[3], this.forecastedIndexValueTime[3]));
                }
            }
            int i = 0;
            while (i < this.symbolNamber) {
                String symbol = this.symbolsName.get(i);
                if (this.isSymbolCumulantPresent[i][0]) {
                    this.checkResult(portfolio.addUserData(String.valueOf(symbol) + "ExpReturn", this.forecastedSymbolValue[i][0], this.forecastedSymbolValueTime[i][0]));
                }
                if (this.isSymbolCumulantPresent[i][1]) {
                    this.checkResult(portfolio.addUserData(String.valueOf(symbol) + "Variance", this.forecastedSymbolValue[i][1], this.forecastedSymbolValueTime[i][1]));
                }
                if (this.isSymbolCumulantPresent[i][2]) {
                    if (this.isCumulants[i][0]) {
                        this.checkResult(portfolio.addUserData(String.valueOf(symbol) + "Cumulant3", this.forecastedSymbolValue[i][2], this.forecastedSymbolValueTime[i][2]));
                    } else {
                        this.checkResult(portfolio.addUserData(String.valueOf(symbol) + "Skewness", this.forecastedSymbolValue[i][2], this.forecastedSymbolValueTime[i][2]));
                    }
                }
                if (this.isSymbolCumulantPresent[i][3]) {
                    if (this.isCumulants[i][1]) {
                        this.checkResult(portfolio.addUserData(String.valueOf(symbol) + "Cumulant4", this.forecastedSymbolValue[i][2], this.forecastedSymbolValueTime[i][3]));
                    } else {
                        this.checkResult(portfolio.addUserData(String.valueOf(symbol) + "Kurtosis", this.forecastedSymbolValue[i][2], this.forecastedSymbolValueTime[i][3]));
                    }
                }
                if (this.isSymbolCumulantPresent[i][4]) {
                    this.checkResult(portfolio.addUserData(String.valueOf(symbol) + "Beta", this.forecastedSymbolValue[i][4], this.forecastedSymbolValueTime[i][4]));
                }
                ++i;
            }
        }
        catch (Exception e) {
            return new MethodResult(e.getMessage());
        }
        return new MethodResult();
    }
}

