% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/antiChain.R
\name{antiChain}
\alias{antiChain}
\title{Generate an anti-chain from a vector of elements' labels}
\usage{
antiChain(elements)
}
\arguments{
\item{elements}{a vector of characters with elements' labels.}
}
\value{
an environment of class \code{poset}.
}
\description{
The function produces an antichain from the vector of elements' labels \code{elements}.
If \code{elements} is a numeric vector, it is first coerced to a character vector.

An antichain is a poset with no comparabilities, therefore the order of the labels in
\code{elements} does not matter.
}
\examples{
antiChain(LETTERS[1:5])
}
\seealso{
function \code{\link[POSetR]{poset}} for more details and to create a generic poset and function \code{\link[POSetR]{chain}} to create a complete order.
}
