% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pl_subset.R
\name{pl_subset}
\alias{pl_subset}
\title{Subset to a Summary Level}
\usage{
pl_subset(pl, sumlev = "750")
}
\arguments{
\item{pl}{A list of PL tables, as read in by \code{\link[=pl_read]{pl_read()}}}

\item{sumlev}{the summary level to filter to. A 3 character SUMLEV code. Default is '750' for blocks.}
}
\value{
tibble
}
\description{
This subsets a pl table to a desired summary level. Typical choices include:
\itemize{
\item '750': block
\item '150': block group
\item '630': voting district
\item '050': county
}
}
\details{
All summary levels are listed in \link{pl_geog_levels}.
}
\examples{
pl_ex_path <- system.file('extdata/ri2018_2020Style.pl', package = 'PL94171')
pl <- pl_read(pl_ex_path)
pl <- pl_subset(pl)
}
