% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_vpin.R
\name{vpin}
\alias{vpin}
\title{Estimation of Volume-Synchronized PIN model}
\usage{
vpin(data, timebarsize = 60, buckets = 50, samplength = 50,
            tradinghours = 24, verbose = TRUE)
}
\arguments{
\item{data}{A dataframe with 3 variables:
\code{{timestamp, price, volume}}.}

\item{timebarsize}{An integer referring to  the size of timebars
in seconds. The default value is \code{60}.}

\item{buckets}{An integer referring to the number of buckets in a
daily average volume. The default value is \code{50}.}

\item{samplength}{An integer referring to the sample length
or the window size used to calculate the \code{VPIN} vector.
The default value is \code{50}.}

\item{tradinghours}{An integer referring to the length of daily
trading sessions in hours. The default value is \code{24}.}

\item{verbose}{A binary variable that determines whether detailed
information about the steps of the estimation of the VPIN model is displayed.
No output is produced when \code{verbose} is set to \code{FALSE}. The default
value is \code{TRUE}.}
}
\value{
Returns an object of class \code{estimate.vpin}.
}
\description{
Estimates the Volume-Synchronized Probability of Informed
Trading as developed in \insertCite{Easley2011;textual}{PINstimation}
and \insertCite{Easley2012;textual}{PINstimation}.
}
\details{
The dataframe data should contain at least three variables. Only the
first three variables will be considered and in the following order
\code{{timestamp, price, volume}}.

The property \code{@bucketdata} is created as in
\insertCite{abad2012;textual}{PINstimation}.

The argument \code{timebarsize} is in seconds enabling the user to implement
shorter than \code{1} minute intervals. The default value is set to \code{1} minute
(\code{60} seconds) following Easley et al. (2011, 2012).

The parameter \code{tradinghours} is used to eventually correct the duration per
bucket. The duration of a given bucket is the difference between the
timestamp of the last trade \code{endtime} and the timestamp of the first trade
\code{stime} in the bucket. If the first trade and the last trade in a
bucket occur in two different days, and the market trading session does not
cover a full day \code{(24 hours)}; then the duration of the bucket will be
inflated. Assume that the daily trading session is 8 hours
\code{(tradinghours=8)}, the start time of a bucket is \code{2018-10-12 17:06:40}
and its end time is \code{2018-10-13 09:36:00}. A straightforward calculation
gives that the duration of this bucket is \code{59,360 secs}. However, this
duration includes the time during which the market is closed \verb{(16 hours)}.
The corrected duration takes into consideration only the time of market
activity: \verb{duration=59,360-16*3600= 1760 secs}, i.e., about \verb{30 minutes}.
}
\examples{
# There is a preloaded dataset called 'hfdata' contained in the package.
# It is an artificially created high-frequency trading data. The dataset
# contains 100 000 trades and five variables 'timestamp', 'price',
# 'volume', 'bid' and 'ask'. For more information, type ?hfdata.

xdata <- hfdata

# Estimate VPIN model, using the following parameter set where the time
# bar size is 5 minutes, i.e., 300 seconds (timebarsize = 300), 50
# buckets per average daily volume (buckets = 50), and a window size of
# 250 for the VPIN calculation (samplength = 250).

estimate <- vpin(xdata, timebarsize = 300, buckets = 50, samplength = 250)

# Display a description of the estimate

show(estimate)

# Plot the estimated VPIN vector

plot(estimate@vpin, type = "l", xlab = "time", ylab = "VPIN", col = "blue")

# Display the parameters of VPIN estimates

show(estimate@parameters)

# Store the computed data of the different buckets in a dataframe 'buckets'.
# Display the first 10 rows of the dataframe 'buckets'.

buckets <- estimate@bucketdata
show(head(buckets, 10))

# Store the daily VPIN values (weighted and unweighted) in a dataframe
# 'dayvpin'.

# Display the first 10 rows of the dataframe 'dayvpin'.

dayvpin <- estimate@dailyvpin
show(head(dayvpin, 10))

}
\references{
\insertAllCited
}
