% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ba_plot.R
\name{ba_plot}
\alias{ba_plot}
\title{Create a Bland-Altman plot}
\usage{
ba_plot(plotdata, x_var, y_var, x_name, y_name, shape = 16, ...)
}
\arguments{
\item{plotdata}{dataframe from which to build the plot}

\item{x_var}{character expression to evaluate for the x-axis}

\item{y_var}{character expression to evaluate for the y-axis}

\item{x_name}{axis label for the x-axis}

\item{y_name}{axis label for the y-axis}

\item{shape}{numeric. The point shape to display.}

\item{...}{further arguments passed to \code{theme}}
}
\value{
a Bland-Altman plot
}
\description{
Create a Bland-Altman plot
}
\examples{
data(ex_data, package = "PAutilities")

# Reduce the number of data points (for illustration purposes) by isolating
# the 150 largest cases

illustration_threshold <-
    quantile(ex_data$Axis1, probs = 1 - (150 / nrow(ex_data)))
ex_data <- ex_data[ex_data$Axis1 > illustration_threshold, ]

# Generate the plot
my_ba <- ba_plot(
    ex_data,
    "(Axis1 + Axis3) / 2",
    "Axis1 - Axis3",
    "mean(Axis1, Axis3)",
    "Axis1 - Axis3"
)

my_ba

\donttest{
# You can add to the plot as you would a normal ggplot object
    my_ba +
      ggplot2::geom_text(
      x = 2000, y = 9000, label = "A",
      size = 8, fontface = "bold", colour = "blue"
      )

# With caution, you can change some automatic options (e.g. color of
# regression line) by overwriting in a new layer

    my_ba + ggplot2::geom_smooth(method = "lm", se = FALSE, colour = "blue")

}
}
\references{
Bland, J. M., & Altman, D. G. (1986). Statistical methods for
  assessing agreement between two methods of clinical measurement. lancet,
  1(8476), 307-310.
}
