% Generated by roxygen2 (4.0.2): do not edit by hand
\name{mxComputeNumericDeriv}
\alias{MxComputeNumericDeriv-class}
\alias{mxComputeNumericDeriv}
\title{Numerically estimate Hessian using Richardson extrapolation}
\usage{
mxComputeNumericDeriv(freeSet = NA_character_, ...,
  fitfunction = "fitfunction", parallel = TRUE, stepSize = 1e-04,
  iterations = 4L, verbose = 0L, knownHessian = NULL)
}
\arguments{
\item{freeSet}{names of matrices containing free variables}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{fitfunction}{name of the fitfunction (defaults to 'fitfunction')}

\item{parallel}{whether to evaluate the fitfunction in parallel (defaults to TRUE)}

\item{stepSize}{starting set size (defaults to 0.0001)}

\item{iterations}{number of Richardson extrapolation iterations (defaults to 4L)}

\item{verbose}{Level of debugging output.}

\item{knownHessian}{an optional matrix of known Hessian entries}
}
\description{
For N free parameters, Richardson extrapolation requires
(iterations * (N^2 + N)) function evaluations.
}
\details{
The implementation is closely based on the numDeriv R package.
}
\examples{
library(OpenMx)
data(demoOneFactor)
factorModel <- mxModel(name ="One Factor",
	mxMatrix(type = "Full", nrow = 5, ncol = 1, free = FALSE, values = .2, name = "A"),
	mxMatrix(type = "Symm", nrow = 1, ncol = 1, free = FALSE, values = 1 , name = "L"),
	mxMatrix(type = "Diag", nrow = 5, ncol = 5, free = TRUE , values = 1 , name = "U"),
	mxAlgebra(A \%*\% L \%*\% t(A) + U, name = "R"),
	mxExpectationNormal(covariance = "R", dimnames = names(demoOneFactor)),
	mxFitFunctionML(),
	mxData(cov(demoOneFactor), type = "cov", numObs = 500),
	mxComputeSequence(
		list(mxComputeNumericDeriv(), mxComputeReportDeriv())
	)
)
factorModelFit <- mxRun(factorModel)
factorModelFit$output$hessian
}

